/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3.model.SSEKMSEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectEncryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectEncryption> {
    private static final SdkField<SSEKMSEncryption> SSEKMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSEKMS").getter(ObjectEncryption.getter(ObjectEncryption::ssekms)).setter(ObjectEncryption.setter(Builder::ssekms)).constructor(SSEKMSEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-KMS").unmarshallLocationName("SSE-KMS").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSEKMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ObjectEncryption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SSEKMSEncryption ssekms;
    private final Type type;

    private ObjectEncryption(BuilderImpl builder) {
        this.ssekms = builder.ssekms;
        this.type = builder.type;
    }

    public final SSEKMSEncryption ssekms() {
        return this.ssekms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekms());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectEncryption)) {
            return false;
        }
        ObjectEncryption other = (ObjectEncryption)obj;
        return Objects.equals(this.ssekms(), other.ssekms());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectEncryption").add("SSEKMS", (Object)this.ssekms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SSEKMS": {
                return Optional.ofNullable(clazz.cast(this.ssekms()));
            }
        }
        return Optional.empty();
    }

    public static ObjectEncryption fromSsekms(SSEKMSEncryption ssekms) {
        return (ObjectEncryption)ObjectEncryption.builder().ssekms(ssekms).build();
    }

    public static ObjectEncryption fromSsekms(Consumer<SSEKMSEncryption.Builder> ssekms) {
        SSEKMSEncryption.Builder builder = SSEKMSEncryption.builder();
        ssekms.accept(builder);
        return ObjectEncryption.fromSsekms((SSEKMSEncryption)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SSEKMSEncryption>> map = new HashMap<String, SdkField<SSEKMSEncryption>>();
        map.put("SSE-KMS", SSEKMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectEncryption, T> g) {
        return obj -> g.apply((ObjectEncryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SSEKMS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SSEKMSEncryption ssekms;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectEncryption model) {
            this.ssekms(model.ssekms);
        }

        public final SSEKMSEncryption.Builder getSsekms() {
            return this.ssekms != null ? this.ssekms.toBuilder() : null;
        }

        public final void setSsekms(SSEKMSEncryption.BuilderImpl ssekms) {
            SSEKMSEncryption oldValue = this.ssekms;
            this.ssekms = ssekms != null ? ssekms.build() : null;
            this.handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
        }

        @Override
        public final Builder ssekms(SSEKMSEncryption ssekms) {
            SSEKMSEncryption oldValue = this.ssekms;
            this.ssekms = ssekms;
            this.handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
            return this;
        }

        public ObjectEncryption build() {
            return new ObjectEncryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectEncryption> {
        public Builder ssekms(SSEKMSEncryption var1);

        default public Builder ssekms(Consumer<SSEKMSEncryption.Builder> ssekms) {
            return this.ssekms((SSEKMSEncryption)((SSEKMSEncryption.Builder)SSEKMSEncryption.builder().applyMutation(ssekms)).build());
        }
    }
}

