/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.format.http.HttpHeader;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ArchiveRecord;
import org.archive.io.ArchiveRecordHeader;
import org.archive.util.LaxHttpParser;

public class WARCRecord
extends ArchiveRecord {
    private Pattern WHITESPACE = Pattern.compile("\\s");

    public WARCRecord(InputStream in, String identifier, long offset) throws IOException {
        this(in, identifier, offset, true, false);
    }

    public WARCRecord(InputStream in, ArchiveRecordHeader headers) throws IOException {
        super(in, headers, 0, true, false);
    }

    public WARCRecord(InputStream in, String identifier, long offset, boolean digest, boolean strict) throws IOException {
        super(in, null, 0, digest, strict);
        this.setHeader(this.parseHeaders(in, identifier, offset, strict));
    }

    protected ArchiveRecordHeader parseHeaders(InputStream in, String identifier, long offset, boolean strict) throws IOException {
        String firstLine;
        final HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("absolute-offset", new Long(offset));
        m.put("reader-identifier", identifier);
        long startPosition = -1L;
        if (in instanceof RepositionableStream) {
            startPosition = ((RepositionableStream)((Object)in)).position();
        }
        if ((firstLine = new String(LaxHttpParser.readLine(in, WARCConstants.WARC_HEADER_ENCODING))) == null || firstLine.length() <= 0) {
            throw new IOException("Failed to read WARC_MAGIC");
        }
        if (!firstLine.startsWith("WARC/")) {
            throw new IOException("Failed to find WARC MAGIC: " + firstLine);
        }
        HttpHeader[] h = LaxHttpParser.parseHeaders(in, WARCConstants.WARC_HEADER_ENCODING);
        for (int i = 0; i < h.length; ++i) {
            m.put(h[i].getName(), h[i].getValue());
        }
        int headerLength = -1;
        if (in instanceof RepositionableStream) {
            headerLength = (int)(((RepositionableStream)((Object)in)).position() - startPosition);
        }
        final int contentOffset = headerLength;
        this.incrementPosition(contentOffset);
        return new ArchiveRecordHeader(){
            private Map<String, Object> headers;
            private int contentBegin;
            final /* synthetic */ WARCRecord this$0;
            {
                this.this$0 = this$0;
                this.headers = m;
                this.contentBegin = contentOffset;
            }

            @Override
            public String getDate() {
                return (String)this.headers.get("WARC-Date");
            }

            @Override
            public String getDigest() {
                return null;
            }

            @Override
            public String getReaderIdentifier() {
                return (String)this.headers.get("reader-identifier");
            }

            @Override
            public Set<String> getHeaderFieldKeys() {
                return this.headers.keySet();
            }

            @Override
            public Map<String, Object> getHeaderFields() {
                return this.headers;
            }

            @Override
            public Object getHeaderValue(String key) {
                return this.headers.get(key);
            }

            @Override
            public long getContentLength() {
                Object o = this.headers.get("Content-Length");
                if (o == null) {
                    return -1L;
                }
                long contentLength = o instanceof Long ? (Long)o : Long.parseLong((String)o);
                return contentLength;
            }

            @Override
            public long getLength() {
                return this.getContentLength() + (long)contentOffset;
            }

            @Override
            public String getMimetype() {
                return (String)this.headers.get("Content-Type");
            }

            @Override
            public long getOffset() {
                Object o = this.headers.get("absolute-offset");
                if (o == null) {
                    return -1L;
                }
                return o instanceof Long ? (Long)o : Long.parseLong((String)o);
            }

            @Override
            public String getRecordIdentifier() {
                return (String)this.headers.get("record-identifier");
            }

            @Override
            public String getUrl() {
                return (String)this.headers.get("WARC-Target-URI");
            }

            @Override
            public String getVersion() {
                return (String)this.headers.get("version");
            }

            @Override
            public int getContentBegin() {
                return this.contentBegin;
            }

            @Override
            public String toString() {
                return this.headers.toString();
            }
        };
    }

    @Override
    protected String getMimetype4Cdx(ArchiveRecordHeader h) {
        String m = super.getMimetype4Cdx(h);
        Matcher matcher = this.WHITESPACE.matcher(m);
        return matcher.replaceAll("");
    }
}

