/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.jexl3.JexlCache;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Frame;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.Source;
import org.apache.commons.jexl3.internal.TemplateInterpreter;
import org.apache.commons.jexl3.internal.TemplateScript;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.StringParser;
import org.apache.commons.logging.Log;

public final class TemplateEngine
extends JxltEngine {
    final JexlCache<Source, Object> cache;
    final Engine jexl;
    final Log logger;
    final char immediateChar;
    final char deferredChar;
    final boolean noscript;

    private static int append(StringBuilder strb, CharSequence expr, int position, char c) {
        int index;
        strb.append(c);
        if (c != '\"' && c != '\'') {
            return position;
        }
        int end = expr.length();
        boolean escape = false;
        for (index = position + 1; index < end; ++index) {
            char ec = expr.charAt(index);
            strb.append(ec);
            if (ec == '\\') {
                escape = !escape;
                continue;
            }
            if (escape) {
                escape = false;
                continue;
            }
            if (ec == c) break;
        }
        return index;
    }

    static JxltEngine.Exception createException(JexlInfo info, String action, TemplateExpression expr, Exception xany) {
        String causeMsg;
        Throwable cause;
        StringBuilder strb = new StringBuilder("failed to ");
        strb.append(action);
        if (expr != null) {
            strb.append(" '");
            strb.append(expr);
            strb.append("'");
        }
        if ((cause = xany.getCause()) != null && (causeMsg = cause.getMessage()) != null) {
            strb.append(", ");
            strb.append(causeMsg);
        }
        return new JxltEngine.Exception(info, strb.toString(), (Throwable)xany);
    }

    static Iterator<CharSequence> readLines(final Reader reader) {
        if (!reader.markSupported()) {
            throw new IllegalArgumentException("mark support in reader required");
        }
        return new Iterator<CharSequence>(){
            private CharSequence next = this.doNext();

            private CharSequence doNext() {
                StringBuilder strb = new StringBuilder(64);
                boolean eol = false;
                try {
                    int c;
                    while ((c = reader.read()) >= 0) {
                        if (eol) {
                            reader.reset();
                            break;
                        }
                        if (c == 10) {
                            eol = true;
                        }
                        strb.append((char)c);
                        reader.mark(1);
                    }
                }
                catch (IOException xio) {
                    return null;
                }
                return strb.length() > 0 ? strb : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public CharSequence next() {
                CharSequence current = this.next;
                if (current != null) {
                    this.next = this.doNext();
                }
                return current;
            }
        };
    }

    public TemplateEngine(Engine jexl, boolean noScript, int cacheSize, char immediate, char deferred) {
        this.jexl = jexl;
        this.logger = jexl.logger;
        this.cache = jexl.createCache(cacheSize);
        this.immediateChar = immediate;
        this.deferredChar = deferred;
        this.noscript = noScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        JexlCache<Source, Object> jexlCache = this.cache;
        synchronized (jexlCache) {
            this.cache.clear();
        }
    }

    @Override
    public JxltEngine.Expression createExpression(JexlInfo jexlInfo, String expression) {
        return this.createExpression(jexlInfo, expression, null);
    }

    public JxltEngine.Expression createExpression(JexlInfo jexlInfo, String expression, Scope scope) {
        JexlInfo info = jexlInfo == null ? this.jexl.createInfo() : jexlInfo;
        JxltEngine.Exception xuel = null;
        TemplateExpression stmt = null;
        JexlFeatures features = this.noscript ? this.jexl.expressionFeatures : this.jexl.scriptFeatures;
        boolean cached = this.cache != null && expression.length() < this.jexl.cacheThreshold;
        try {
            if (!cached) {
                stmt = this.parseExpression(info, expression, scope);
            } else {
                Source source = new Source(features, Scope.getSymbolsMap(scope), expression);
                Object c = this.cache.get(source);
                TemplateExpression templateExpression = stmt = c instanceof TemplateExpression ? (TemplateExpression)c : null;
                if (stmt != null) {
                    return stmt;
                }
                stmt = this.parseExpression(info, expression, scope);
                this.cache.put(source, stmt);
            }
        }
        catch (JexlException xjexl) {
            xuel = new JxltEngine.Exception(xjexl.getInfo(), "failed to parse '" + expression + "'", (Throwable)xjexl);
        }
        if (xuel != null) {
            if (!this.jexl.isSilent()) {
                throw xuel;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)xuel.getMessage(), xuel.getCause());
            }
            stmt = null;
        }
        return stmt;
    }

    @Override
    public TemplateScript createTemplate(JexlInfo info, String prefix, Reader source, String ... parms) {
        return new TemplateScript(this, info, prefix, source, parms);
    }

    char getDeferredChar() {
        return this.deferredChar;
    }

    @Override
    public Engine getEngine() {
        return this.jexl;
    }

    char getImmediateChar() {
        return this.immediateChar;
    }

    TemplateExpression parseExpression(JexlInfo info, String expr, Scope scope) {
        int size = expr.length();
        ExpressionBuilder builder = new ExpressionBuilder(0);
        StringBuilder strb = new StringBuilder(size);
        ParseState state = ParseState.CONST;
        int immediate1 = 0;
        int deferred1 = 0;
        int inner1 = 0;
        boolean nested = false;
        int inested = -1;
        int lineno = info.getLine();
        block18: for (int column = 0; column < size; ++column) {
            char c = expr.charAt(column);
            switch (state.ordinal()) {
                case 0: {
                    if (c == this.immediateChar) {
                        state = ParseState.IMMEDIATE0;
                        break;
                    }
                    if (c == this.deferredChar) {
                        inested = column;
                        state = ParseState.DEFERRED0;
                        break;
                    }
                    if (c == '\\') {
                        state = ParseState.ESCAPE;
                        break;
                    }
                    strb.append(c);
                    break;
                }
                case 1: {
                    if (c != '{') {
                        strb.append(this.immediateChar);
                        state = ParseState.CONST;
                        --column;
                        continue block18;
                    }
                    state = ParseState.IMMEDIATE1;
                    if (strb.length() <= 0) break;
                    ConstantExpression cexpr = new ConstantExpression(strb.toString(), null);
                    builder.add(cexpr);
                    strb.delete(0, Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    if (c != '{') {
                        strb.append(this.deferredChar);
                        state = ParseState.CONST;
                        --column;
                        continue block18;
                    }
                    state = ParseState.DEFERRED1;
                    if (strb.length() <= 0) break;
                    ConstantExpression cexpr = new ConstantExpression(strb.toString(), null);
                    builder.add(cexpr);
                    strb.delete(0, Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    JexlInfo srcInfo;
                    String src;
                    if (c == '}') {
                        if (immediate1 > 0) {
                            --immediate1;
                            strb.append(c);
                            break;
                        }
                        src = this.escapeString(strb);
                        srcInfo = info.at(lineno, column);
                        ImmediateExpression iexpr = new ImmediateExpression(src, this.jexl.jxltParse(srcInfo, this.noscript, src, scope), null);
                        builder.add(iexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        state = ParseState.CONST;
                        break;
                    }
                    if (c == '{') {
                        ++immediate1;
                    }
                    column = TemplateEngine.append(strb, expr, column, c);
                    break;
                }
                case 4: {
                    JexlInfo srcInfo;
                    String src;
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            strb.append(c);
                            column = StringParser.readString(strb, expr, column + 1, c);
                            continue block18;
                        }
                        case '{': {
                            if (expr.charAt(column - 1) == this.immediateChar) {
                                ++inner1;
                                strb.deleteCharAt(strb.length() - 1);
                                nested = true;
                                continue block18;
                            }
                            ++deferred1;
                            strb.append(c);
                            continue block18;
                        }
                        case '}': {
                            if (deferred1 > 0) {
                                --deferred1;
                                strb.append(c);
                                break;
                            }
                            if (inner1 > 0) {
                                --inner1;
                                break;
                            }
                            src = this.escapeString(strb);
                            srcInfo = info.at(lineno, column);
                            JexlBasedExpression dexpr = nested ? new NestedExpression(this.escapeString(expr.substring(inested, column + 1)), this.jexl.jxltParse(srcInfo, this.noscript, src, scope), null) : new DeferredExpression(src, this.jexl.jxltParse(srcInfo, this.noscript, src, scope), null);
                            builder.add(dexpr);
                            strb.delete(0, Integer.MAX_VALUE);
                            nested = false;
                            state = ParseState.CONST;
                            break;
                        }
                        default: {
                            column = TemplateEngine.append(strb, expr, column, c);
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    if (c == this.deferredChar) {
                        strb.append(this.deferredChar);
                    } else if (c == this.immediateChar) {
                        strb.append(this.immediateChar);
                    } else {
                        strb.append('\\');
                        strb.append(c);
                    }
                    state = ParseState.CONST;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unexpected unified expression type");
                }
            }
            if (c != '\n') continue;
            ++lineno;
        }
        if (state != ParseState.CONST) {
            switch (state.ordinal()) {
                case 5: {
                    strb.append('\\');
                    strb.append('\\');
                    break;
                }
                case 2: {
                    strb.append(this.deferredChar);
                    break;
                }
                case 1: {
                    strb.append(this.immediateChar);
                    break;
                }
                default: {
                    throw new JxltEngine.Exception(info.at(lineno, 0), "malformed expression: " + expr, null);
                }
            }
        }
        if (strb.length() > 0) {
            ConstantExpression cexpr = new ConstantExpression(strb.toString(), null);
            builder.add(cexpr);
        }
        return builder.build(this, null);
    }

    private String escapeString(CharSequence str) {
        return StringParser.escapeString(str, '\u0000');
    }

    List<Block> readTemplate(String prefix, Reader source) {
        CharSequence line;
        ArrayList<Block> blocks = new ArrayList<Block>();
        BufferedReader reader = source instanceof BufferedReader ? (BufferedReader)source : new BufferedReader(source);
        StringBuilder strb = new StringBuilder();
        BlockType type = null;
        Iterator<CharSequence> lines = TemplateEngine.readLines(reader);
        int lineno = 1;
        int start = 0;
        while (lines.hasNext() && (line = lines.next()) != null) {
            int prefixLen;
            if (type == null) {
                prefixLen = this.startsWith(line, prefix);
                if (prefixLen >= 0) {
                    type = BlockType.DIRECTIVE;
                    strb.append(line.subSequence(prefixLen, line.length()));
                } else {
                    type = BlockType.VERBATIM;
                    strb.append(line.subSequence(0, line.length()));
                }
                start = lineno;
            } else if (type == BlockType.DIRECTIVE) {
                prefixLen = this.startsWith(line, prefix);
                if (prefixLen < 0) {
                    Block directive = new Block(BlockType.DIRECTIVE, start, strb.toString());
                    strb.delete(0, Integer.MAX_VALUE);
                    blocks.add(directive);
                    type = BlockType.VERBATIM;
                    strb.append(line.subSequence(0, line.length()));
                    start = lineno;
                } else {
                    strb.append(line.subSequence(prefixLen, line.length()));
                }
            } else {
                prefixLen = this.startsWith(line, prefix);
                if (prefixLen >= 0) {
                    Block verbatim = new Block(BlockType.VERBATIM, start, strb.toString());
                    strb.delete(0, Integer.MAX_VALUE);
                    blocks.add(verbatim);
                    type = BlockType.DIRECTIVE;
                    strb.append(line.subSequence(prefixLen, line.length()));
                    start = lineno;
                } else {
                    strb.append(line.subSequence(0, line.length()));
                }
            }
            ++lineno;
        }
        if (type != null && strb.length() > 0) {
            Block block = new Block(type, start, strb.toString());
            blocks.add(block);
        }
        blocks.trimToSize();
        return blocks;
    }

    int startsWith(CharSequence sequence, CharSequence pattern) {
        CharSequence subSequence;
        int s;
        int length = sequence.length();
        for (s = 0; s < length && Character.isSpaceChar(sequence.charAt(s)); ++s) {
        }
        if (s < length && pattern.length() <= length - s && (subSequence = sequence.subSequence(s, length)).subSequence(0, pattern.length()).equals(pattern)) {
            return s + pattern.length();
        }
        return -1;
    }

    abstract class TemplateExpression
    implements JxltEngine.Expression {
        protected final TemplateExpression source;

        TemplateExpression(TemplateExpression src) {
            this.source = src != null ? src : this;
        }

        @Override
        public String asString() {
            StringBuilder strb = new StringBuilder();
            this.asString(strb);
            return strb.toString();
        }

        protected abstract Object evaluate(Interpreter var1);

        @Override
        public final Object evaluate(JexlContext context) {
            return this.evaluate(context, null, null);
        }

        protected final Object evaluate(JexlContext context, Frame frame, JexlOptions options) {
            try {
                TemplateInterpreter.Arguments args = new TemplateInterpreter.Arguments(TemplateEngine.this.jexl).context(context).options(options != null ? options : this.options(context)).frame(frame);
                Interpreter interpreter = TemplateEngine.this.jexl.createTemplateInterpreter(args);
                return this.evaluate(interpreter);
            }
            catch (JexlException xjexl) {
                JxltEngine.Exception xuel = TemplateEngine.createException(xjexl.getInfo(), "evaluate", this, xjexl);
                if (TemplateEngine.this.jexl.isSilent()) {
                    if (TemplateEngine.this.logger.isWarnEnabled()) {
                        TemplateEngine.this.logger.warn((Object)xuel.getMessage(), xuel.getCause());
                    }
                    return null;
                }
                throw xuel;
            }
        }

        JexlInfo getInfo() {
            return null;
        }

        @Override
        public final TemplateExpression getSource() {
            return this.source;
        }

        abstract ExpressionType getType();

        @Override
        public Set<List<String>> getVariables() {
            return Collections.emptySet();
        }

        protected void getVariables(Engine.VarCollector collector) {
        }

        @Override
        public final boolean isDeferred() {
            return !this.isImmediate();
        }

        @Override
        public boolean isImmediate() {
            return true;
        }

        protected JexlOptions options(JexlContext context) {
            return TemplateEngine.this.jexl.evalOptions(null, context);
        }

        protected TemplateExpression prepare(Interpreter interpreter) {
            return this;
        }

        @Override
        public final TemplateExpression prepare(JexlContext context) {
            return this.prepare(context, null, null);
        }

        protected final TemplateExpression prepare(JexlContext context, Frame frame, JexlOptions opts) {
            try {
                JexlOptions interOptions = opts != null ? opts : TemplateEngine.this.jexl.evalOptions(context);
                Interpreter interpreter = TemplateEngine.this.jexl.createInterpreter(context, frame, interOptions);
                return this.prepare(interpreter);
            }
            catch (JexlException xjexl) {
                JxltEngine.Exception xuel = TemplateEngine.createException(xjexl.getInfo(), "prepare", this, xjexl);
                if (TemplateEngine.this.jexl.isSilent()) {
                    if (TemplateEngine.this.logger.isWarnEnabled()) {
                        TemplateEngine.this.logger.warn((Object)xuel.getMessage(), xuel.getCause());
                    }
                    return null;
                }
                throw xuel;
            }
        }

        @Override
        public final String toString() {
            StringBuilder strb = new StringBuilder();
            this.asString(strb);
            if (this.source != this) {
                strb.append(" /*= ");
                strb.append(this.source);
                strb.append(" */");
            }
            return strb.toString();
        }
    }

    static final class ExpressionBuilder {
        private final int[] counts = new int[]{0, 0, 0};
        private final List<TemplateExpression> expressions;

        ExpressionBuilder(int size) {
            this.expressions = new ArrayList<TemplateExpression>(size <= 0 ? 3 : size);
        }

        void add(TemplateExpression expr) {
            int n = expr.getType().getIndex();
            this.counts[n] = this.counts[n] + 1;
            this.expressions.add(expr);
        }

        TemplateExpression build(TemplateEngine el, TemplateExpression source) {
            int sum = 0;
            for (int count : this.counts) {
                sum += count;
            }
            if (this.expressions.size() != sum) {
                StringBuilder error = new StringBuilder("parsing algorithm error: ");
                throw new IllegalStateException(this.toString(error).toString());
            }
            if (this.expressions.size() == 1) {
                return this.expressions.get(0);
            }
            TemplateEngine templateEngine = el;
            Objects.requireNonNull(templateEngine);
            return templateEngine.new CompositeExpression(this.counts, this.expressions, source);
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        StringBuilder toString(StringBuilder error) {
            error.append("exprs{");
            error.append(this.expressions.size());
            error.append(", constant:");
            error.append(this.counts[ExpressionType.CONSTANT.getIndex()]);
            error.append(", immediate:");
            error.append(this.counts[ExpressionType.IMMEDIATE.getIndex()]);
            error.append(", deferred:");
            error.append(this.counts[ExpressionType.DEFERRED.getIndex()]);
            error.append("}");
            return error;
        }
    }

    private static enum ParseState {
        CONST,
        IMMEDIATE0,
        DEFERRED0,
        IMMEDIATE1,
        DEFERRED1,
        ESCAPE;

    }

    final class ConstantExpression
    extends TemplateExpression {
        private final Object value;

        ConstantExpression(Object val, TemplateExpression source) {
            super(source);
            Objects.requireNonNull(val, "val");
            this.value = val instanceof String ? StringParser.buildTemplate((String)val, false) : val;
        }

        @Override
        public StringBuilder asString(StringBuilder strb) {
            if (this.value != null) {
                strb.append(this.value);
            }
            return strb;
        }

        @Override
        protected Object evaluate(Interpreter interpreter) {
            return this.value;
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.CONSTANT;
        }
    }

    final class ImmediateExpression
    extends JexlBasedExpression {
        ImmediateExpression(CharSequence expr, JexlNode node, TemplateExpression source) {
            super(expr, node, source);
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.IMMEDIATE;
        }

        @Override
        protected TemplateExpression prepare(Interpreter interpreter) {
            Object value = this.evaluate(interpreter);
            return value != null ? new ConstantExpression(value, this.source) : null;
        }
    }

    final class NestedExpression
    extends JexlBasedExpression {
        NestedExpression(CharSequence expr, JexlNode node, TemplateExpression source) {
            super(expr, node, source);
            if (this.source != this) {
                throw new IllegalArgumentException("Nested TemplateExpression cannot have a source");
            }
        }

        @Override
        public StringBuilder asString(StringBuilder strb) {
            strb.append(this.expr);
            return strb;
        }

        @Override
        protected Object evaluate(Interpreter interpreter) {
            return this.prepare(interpreter).evaluate(interpreter);
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.NESTED;
        }

        @Override
        public boolean isImmediate() {
            return false;
        }

        @Override
        protected TemplateExpression prepare(Interpreter interpreter) {
            String value = interpreter.interpret(this.node).toString();
            ASTJexlScript dnode = TemplateEngine.this.jexl.jxltParse(this.node.jexlInfo(), TemplateEngine.this.noscript, value, null);
            return new ImmediateExpression(value, dnode, this);
        }
    }

    final class DeferredExpression
    extends JexlBasedExpression {
        DeferredExpression(CharSequence expr, JexlNode node, TemplateExpression source) {
            super(expr, node, source);
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.DEFERRED;
        }

        @Override
        protected void getVariables(Engine.VarCollector collector) {
        }

        @Override
        public boolean isImmediate() {
            return false;
        }

        @Override
        protected TemplateExpression prepare(Interpreter interpreter) {
            return new ImmediateExpression(this.expr, this.node, this.source);
        }
    }

    static enum BlockType {
        VERBATIM,
        DIRECTIVE;

    }

    static final class Block {
        private final BlockType type;
        private final int line;
        private final String body;

        Block(BlockType theType, int theLine, String theBlock) {
            this.type = theType;
            this.line = theLine;
            this.body = theBlock;
        }

        String getBody() {
            return this.body;
        }

        int getLine() {
            return this.line;
        }

        BlockType getType() {
            return this.type;
        }

        void toString(StringBuilder strb, String prefix) {
            if (BlockType.VERBATIM.equals((Object)this.type)) {
                strb.append(this.body);
            } else {
                Iterator<CharSequence> lines = TemplateEngine.readLines(new StringReader(this.body));
                while (lines.hasNext()) {
                    strb.append(prefix).append(lines.next());
                }
            }
        }
    }

    abstract class JexlBasedExpression
    extends TemplateExpression {
        protected final CharSequence expr;
        protected final JexlNode node;

        protected JexlBasedExpression(CharSequence theExpr, JexlNode theNode, TemplateExpression theSource) {
            super(theSource);
            this.expr = theExpr;
            this.node = theNode;
        }

        @Override
        public StringBuilder asString(StringBuilder strb) {
            strb.append(this.isImmediate() ? TemplateEngine.this.immediateChar : TemplateEngine.this.deferredChar);
            strb.append("{");
            strb.append(this.expr);
            strb.append("}");
            return strb;
        }

        @Override
        protected Object evaluate(Interpreter interpreter) {
            return interpreter.interpret(this.node);
        }

        @Override
        JexlInfo getInfo() {
            return this.node.jexlInfo();
        }

        @Override
        public Set<List<String>> getVariables() {
            Engine.VarCollector collector = TemplateEngine.this.jexl.varCollector();
            this.getVariables(collector);
            return collector.collected();
        }

        @Override
        protected void getVariables(Engine.VarCollector collector) {
            TemplateEngine.this.jexl.getVariables(this.node instanceof ASTJexlScript ? (ASTJexlScript)this.node : null, this.node, collector);
        }

        @Override
        protected JexlOptions options(JexlContext context) {
            return TemplateEngine.this.jexl.evalOptions(this.node instanceof ASTJexlScript ? (ASTJexlScript)this.node : null, context);
        }
    }

    static enum ExpressionType {
        CONSTANT(0),
        IMMEDIATE(1),
        DEFERRED(2),
        NESTED(2),
        COMPOSITE(-1);

        private final int index;

        private ExpressionType(int idx) {
            this.index = idx;
        }

        int getIndex() {
            return this.index;
        }
    }

    final class CompositeExpression
    extends TemplateExpression {
        private final int meta;
        final TemplateExpression[] exprs;

        CompositeExpression(int[] counters, List<TemplateExpression> list, TemplateExpression src) {
            super(src);
            this.exprs = list.toArray(new TemplateExpression[0]);
            this.meta = (counters[ExpressionType.DEFERRED.getIndex()] > 0 ? 2 : 0) | (counters[ExpressionType.IMMEDIATE.getIndex()] > 0 ? 1 : 0);
        }

        @Override
        public StringBuilder asString(StringBuilder strb) {
            for (TemplateExpression e : this.exprs) {
                e.asString(strb);
            }
            return strb;
        }

        @Override
        protected Object evaluate(Interpreter interpreter) {
            StringBuilder strb = new StringBuilder();
            for (TemplateExpression expr : this.exprs) {
                Object value = expr.evaluate(interpreter);
                if (value == null) continue;
                strb.append(value);
            }
            return strb.toString();
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.COMPOSITE;
        }

        @Override
        public Set<List<String>> getVariables() {
            Engine.VarCollector collector = TemplateEngine.this.jexl.varCollector();
            for (TemplateExpression expr : this.exprs) {
                expr.getVariables(collector);
            }
            return collector.collected();
        }

        @Override
        protected void getVariables(Engine.VarCollector collector) {
            for (TemplateExpression expr : this.exprs) {
                expr.getVariables(collector);
            }
        }

        @Override
        public boolean isImmediate() {
            return (this.meta & 2) == 0;
        }

        @Override
        protected TemplateExpression prepare(Interpreter interpreter) {
            if (this.source != this) {
                return this;
            }
            int size = this.exprs.length;
            ExpressionBuilder builder = new ExpressionBuilder(size);
            boolean eq = true;
            for (TemplateExpression expr : this.exprs) {
                TemplateExpression prepared = expr.prepare(interpreter);
                if (prepared != null) {
                    builder.add(prepared);
                }
                eq &= expr == prepared;
            }
            return eq ? this : builder.build(TemplateEngine.this, this);
        }
    }
}

