/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.hostdb;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.hostdb.HostDatum;
import org.apache.nutch.metrics.ErrorTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String host = null;
    protected HostDatum datum = null;
    protected Text hostText = new Text();
    protected Reducer.Context context;
    protected int purgeFailedHostsThreshold;
    private Counter newKnownHostCounter;
    private Counter rediscoveredHostCounter;
    private Counter existingKnownHostCounter;
    private Counter newUnknownHostCounter;
    private Counter existingUnknownHostCounter;
    private Counter purgedUnknownHostCounter;
    private Counter checkedHostsCounter;
    private Counter errorsCounter;
    private Counter errorsNetworkCounter;

    public ResolverThread(String host, HostDatum datum, Reducer.Context context, int purgeFailedHostsThreshold) {
        this.hostText.set(host);
        this.host = host;
        this.datum = datum;
        this.context = context;
        this.purgeFailedHostsThreshold = purgeFailedHostsThreshold;
        this.initCounters();
    }

    private void initCounters() {
        this.newKnownHostCounter = this.context.getCounter("nutch_hostdb", "new_known_host_total");
        this.rediscoveredHostCounter = this.context.getCounter("nutch_hostdb", "rediscovered_host_total");
        this.existingKnownHostCounter = this.context.getCounter("nutch_hostdb", "existing_known_host_total");
        this.newUnknownHostCounter = this.context.getCounter("nutch_hostdb", "new_unknown_host_total");
        this.existingUnknownHostCounter = this.context.getCounter("nutch_hostdb", "existing_unknown_host_total");
        this.purgedUnknownHostCounter = this.context.getCounter("nutch_hostdb", "purged_unknown_host_total");
        this.checkedHostsCounter = this.context.getCounter("nutch_hostdb", "checked_hosts_total");
        this.errorsCounter = this.context.getCounter("nutch_hostdb", "errors_total");
        this.errorsNetworkCounter = this.context.getCounter("nutch_hostdb", "errors_network_total");
    }

    @Override
    public void run() {
        try {
            InetAddress inetAddr = InetAddress.getByName(this.host);
            if (this.datum.isEmpty()) {
                this.newKnownHostCounter.increment(1L);
                this.datum.setLastCheck();
                LOG.info("{}: new_known_host {}", (Object)this.host, (Object)this.datum);
            } else if (this.datum.getDnsFailures() > 0L) {
                this.rediscoveredHostCounter.increment(1L);
                this.datum.setLastCheck();
                this.datum.setDnsFailures(0L);
                LOG.info("{}: rediscovered_host {}", (Object)this.host, (Object)this.datum);
            } else {
                this.existingKnownHostCounter.increment(1L);
                this.datum.setLastCheck();
                LOG.info("{}: existing_known_host {}", (Object)this.host, (Object)this.datum);
            }
            this.context.write((Object)this.hostText, (Object)this.datum);
        }
        catch (UnknownHostException e) {
            try {
                if (this.datum.isEmpty()) {
                    this.datum.setLastCheck();
                    this.datum.setDnsFailures(1L);
                    this.context.write((Object)this.hostText, (Object)this.datum);
                    this.newUnknownHostCounter.increment(1L);
                    LOG.info("{}: new_unknown_host {}", (Object)this.host, (Object)this.datum);
                } else {
                    this.datum.setLastCheck();
                    this.datum.incDnsFailures();
                    if (this.purgeFailedHostsThreshold == -1 || (long)this.purgeFailedHostsThreshold < this.datum.getDnsFailures()) {
                        this.context.write((Object)this.hostText, (Object)this.datum);
                        this.existingUnknownHostCounter.increment(1L);
                        LOG.info("{}: existing_unknown_host {}", (Object)this.host, (Object)this.datum);
                    } else {
                        this.purgedUnknownHostCounter.increment(1L);
                        LOG.info("{}: purged_unknown_host {}", (Object)this.host, (Object)this.datum);
                    }
                }
                this.context.getCounter("nutch_hostdb", this.createFailureCounterLabel(this.datum)).increment(1L);
                this.errorsCounter.increment(1L);
                this.errorsNetworkCounter.increment(1L);
            }
            catch (Exception ioe) {
                LOG.warn(StringUtils.stringifyException((Throwable)ioe));
                this.context.getCounter("nutch_hostdb", "errors_total").increment(1L);
                this.context.getCounter("nutch_hostdb", ErrorTracker.getCounterName(ioe)).increment(1L);
            }
        }
        catch (Exception e) {
            LOG.warn(StringUtils.stringifyException((Throwable)e));
            this.errorsCounter.increment(1L);
            this.context.getCounter("nutch_hostdb", ErrorTracker.getCounterName(e)).increment(1L);
        }
        this.checkedHostsCounter.increment(1L);
    }

    private String createFailureCounterLabel(HostDatum datum) {
        String label = null;
        long n = datum.numFailures();
        label = n < 4L ? Long.toString(n) : (n > 3L && n < 11L ? "4-10" : ">10");
        return label + "_times_failed";
    }
}

