/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.version.Version;

public final class VersionCodec {
    private static final int MAJOR_FIELD_OFFSET = 0;
    private static final int MINOR_FIELD_OFFSET = 1;
    private static final int INITIAL_FRAME_SIZE = 2;

    private VersionCodec() {
    }

    public static void encode(ClientMessage clientMessage, Version version) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[2]);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 0, version.getMajor());
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 1, version.getMinor());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static Version decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        byte major = FixedSizeTypesCodec.decodeByte(initialFrame.content, 0);
        byte minor = FixedSizeTypesCodec.decodeByte(initialFrame.content, 1);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createVersion(major, minor);
    }
}

