/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.client.cache.impl.ClientCacheProxyFactory;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddDistributedObjectListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientCreateProxiesCodec;
import com.hazelcast.client.impl.protocol.codec.ClientCreateProxyCodec;
import com.hazelcast.client.impl.protocol.codec.ClientRemoveDistributedObjectListenerCodec;
import com.hazelcast.client.impl.proxy.ClientCardinalityEstimatorProxy;
import com.hazelcast.client.impl.proxy.ClientDurableExecutorServiceProxy;
import com.hazelcast.client.impl.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.impl.proxy.ClientFlakeIdGeneratorProxy;
import com.hazelcast.client.impl.proxy.ClientListProxy;
import com.hazelcast.client.impl.proxy.ClientMultiMapProxy;
import com.hazelcast.client.impl.proxy.ClientPNCounterProxy;
import com.hazelcast.client.impl.proxy.ClientQueueProxy;
import com.hazelcast.client.impl.proxy.ClientReliableTopicProxy;
import com.hazelcast.client.impl.proxy.ClientReplicatedMapProxy;
import com.hazelcast.client.impl.proxy.ClientRingbufferProxy;
import com.hazelcast.client.impl.proxy.ClientScheduledExecutorProxy;
import com.hazelcast.client.impl.proxy.ClientSetProxy;
import com.hazelcast.client.impl.proxy.ClientTopicProxy;
import com.hazelcast.client.impl.proxy.txn.xa.XAResourceProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.ClientProxyDescriptor;
import com.hazelcast.client.impl.spi.ClientProxyDescriptorProvider;
import com.hazelcast.client.impl.spi.ClientProxyFactory;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientServiceNotFoundException;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.impl.spi.impl.listener.LazyDistributedObjectEvent;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.longregister.client.ClientLongRegisterProxy;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.map.impl.MapService;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public final class ProxyManager {
    private static final String PROVIDER_ID = ClientProxyDescriptorProvider.class.getCanonicalName();
    private static final Class[] LEGACY_CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{String.class, String.class};
    private static final Class[] CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{String.class, String.class, ClientContext.class};
    private final ConcurrentMap<String, ClientProxyFactory> proxyFactories = new ConcurrentHashMap<String, ClientProxyFactory>();
    private final ConcurrentMap<ObjectNamespace, ClientProxyFuture> proxies = new ConcurrentHashMap<ObjectNamespace, ClientProxyFuture>();
    private final HazelcastClientInstanceImpl client;
    private ClientContext context;

    public ProxyManager(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public void init(ClientConfig config, ClientContext clientContext) {
        this.context = clientContext;
        this.register("hz:impl:mapService", this.createServiceProxyFactory(MapService.class));
        if (JCacheDetector.isJCacheAvailable(config.getClassLoader())) {
            this.register("hz:impl:cacheService", new ClientCacheProxyFactory(this.client));
        }
        this.register("hz:impl:queueService", ClientQueueProxy.class);
        this.register("hz:impl:multiMapService", ClientMultiMapProxy.class);
        this.register("hz:impl:listService", ClientListProxy.class);
        this.register("hz:impl:setService", ClientSetProxy.class);
        this.register("hz:impl:topicService", ClientTopicProxy.class);
        this.register("hz:impl:executorService", ClientExecutorServiceProxy.class);
        this.register("hz:impl:durableExecutorService", ClientDurableExecutorServiceProxy.class);
        this.register("hz:impl:replicatedMapService", ClientReplicatedMapProxy.class);
        this.register("hz:impl:xaService", XAResourceProxy.class);
        this.register("hz:impl:ringbufferService", ClientRingbufferProxy.class);
        this.register("hz:impl:reliableTopicService", (String id, ClientContext context) -> new ClientReliableTopicProxy(id, context, this.client));
        this.register("hz:impl:flakeIdGeneratorService", ClientFlakeIdGeneratorProxy.class);
        this.register("hz:impl:cardinalityEstimatorService", ClientCardinalityEstimatorProxy.class);
        this.register("hz:impl:scheduledExecutorService", ClientScheduledExecutorProxy.class);
        this.register("hz:impl:PNCounterService", ClientPNCounterProxy.class);
        this.register("hz:impl:atomicLongService", ClientLongRegisterProxy.class);
        ClassLoader classLoader = config.getClassLoader();
        for (ProxyFactoryConfig proxyFactoryConfig : config.getProxyFactoryConfigs()) {
            try {
                ClientProxyFactory clientProxyFactory = proxyFactoryConfig.getFactoryImpl();
                if (clientProxyFactory == null) {
                    String className = proxyFactoryConfig.getClassName();
                    clientProxyFactory = (ClientProxyFactory)ClassLoaderUtil.newInstance(classLoader, className);
                }
                this.register(proxyFactoryConfig.getService(), clientProxyFactory);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        this.readProxyDescriptors();
    }

    private void readProxyDescriptors() {
        try {
            ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
            Iterator<Class<ClientProxyDescriptorProvider>> iter = ServiceLoader.classIterator(ClientProxyDescriptorProvider.class, PROVIDER_ID, classLoader);
            while (iter.hasNext()) {
                ClientProxyDescriptor[] services;
                Class<ClientProxyDescriptorProvider> clazz = iter.next();
                Constructor<ClientProxyDescriptorProvider> constructor = clazz.getDeclaredConstructor(new Class[0]);
                ClientProxyDescriptorProvider provider = constructor.newInstance(new Object[0]);
                for (ClientProxyDescriptor serviceDescriptor : services = provider.createClientProxyDescriptors()) {
                    this.register(serviceDescriptor.getServiceName(), serviceDescriptor.getClientProxyClass());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <T> ClientProxyFactory createServiceProxyFactory(Class<T> service) {
        ClientExtension clientExtension = this.client.getClientExtension();
        return clientExtension.createServiceProxyFactory(service);
    }

    public ClientContext getContext() {
        return this.context;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.client;
    }

    public ClientProxyFactory getClientProxyFactory(String serviceName) {
        return (ClientProxyFactory)this.proxyFactories.get(serviceName);
    }

    public void register(String serviceName, ClientProxyFactory factory) {
        if (this.proxyFactories.putIfAbsent(serviceName, factory) != null) {
            throw new IllegalArgumentException("Factory for service " + serviceName + " is already registered!");
        }
    }

    public void register(String serviceName, Class<? extends ClientProxy> proxyType) {
        try {
            this.register(serviceName, (String id, ClientContext context) -> (ClientProxy)this.instantiateClientProxy(proxyType, serviceName, context, id));
        }
        catch (Exception e) {
            throw new HazelcastException("Factory for service " + serviceName + " could not be created for " + proxyType, e);
        }
    }

    public ClientProxy getOrCreateProxy(@Nonnull String service, @Nonnull String id) {
        return this.getOrCreateProxyInternal(service, id, true);
    }

    public ClientProxy getOrCreateLocalProxy(@Nonnull String service, @Nonnull String id) {
        return this.getOrCreateProxyInternal(service, id, false);
    }

    private ClientProxy getOrCreateProxyInternal(@Nonnull String service, @Nonnull String id, boolean remote) {
        Preconditions.checkNotNull(service, "Service name is required!");
        Preconditions.checkNotNull(id, "Object name is required!");
        DistributedObjectNamespace ns = new DistributedObjectNamespace(service, id);
        ClientProxyFuture proxyFuture = (ClientProxyFuture)this.proxies.get(ns);
        if (proxyFuture != null) {
            return proxyFuture.get();
        }
        ClientProxyFactory factory = (ClientProxyFactory)this.proxyFactories.get(service);
        if (factory == null) {
            throw new ClientServiceNotFoundException("No factory registered for service: " + service);
        }
        proxyFuture = new ClientProxyFuture();
        ClientProxyFuture current = this.proxies.putIfAbsent(ns, proxyFuture);
        if (current != null) {
            return current.get();
        }
        try {
            ClientProxy clientProxy = this.createClientProxy(id, factory);
            if (remote) {
                this.initialize(clientProxy);
            } else {
                clientProxy.onInitialize();
            }
            proxyFuture.set(clientProxy);
            return clientProxy;
        }
        catch (Throwable e) {
            this.proxies.remove(ns);
            proxyFuture.set(e);
            throw ExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProxy(ClientProxy proxy) {
        block7: {
            DistributedObjectNamespace objectNamespace = new DistributedObjectNamespace(proxy.getServiceName(), proxy.getDistributedObjectName());
            ClientProxyFuture registeredProxyFuture = (ClientProxyFuture)this.proxies.remove(objectNamespace);
            ClientProxy registeredProxy = registeredProxyFuture == null ? null : registeredProxyFuture.get();
            try {
                if (registeredProxy == null) break block7;
                try {
                    registeredProxy.destroyLocally();
                }
                finally {
                    registeredProxy.destroyRemotely();
                }
            }
            finally {
                if (proxy != registeredProxy) {
                    proxy.destroyLocally();
                }
            }
        }
    }

    public void destroyProxyLocally(String service, String id) {
        DistributedObjectNamespace objectNamespace = new DistributedObjectNamespace(service, id);
        ClientProxyFuture clientProxyFuture = (ClientProxyFuture)this.proxies.remove(objectNamespace);
        if (clientProxyFuture != null) {
            ClientProxy clientProxy = clientProxyFuture.get();
            clientProxy.destroyLocally();
        }
    }

    private ClientProxy createClientProxy(String id, ClientProxyFactory factory) {
        return factory.create(id, this.context);
    }

    private void initialize(ClientProxy clientProxy) throws Exception {
        ClientMessage clientMessage = ClientCreateProxyCodec.encodeRequest(clientProxy.getDistributedObjectName(), clientProxy.getServiceName());
        new ClientInvocation(this.client, clientMessage, clientProxy.getServiceName()).invoke().get();
        clientProxy.onInitialize();
    }

    public Collection<? extends DistributedObject> getDistributedObjects() {
        LinkedList<ClientProxy> objects = new LinkedList<ClientProxy>();
        for (ClientProxyFuture future : this.proxies.values()) {
            objects.add(future.get());
        }
        return objects;
    }

    public void destroy() {
        for (ClientProxyFuture future : this.proxies.values()) {
            future.get().onShutdown();
        }
        this.proxies.clear();
    }

    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener listener) {
        DistributedObjectEventHandler eventHandler = new DistributedObjectEventHandler(listener, this);
        return this.client.getListenerService().registerListener(new DistributeObjectListenerMessageCodec(), eventHandler);
    }

    public void createDistributedObjectsOnCluster() {
        LinkedList<Map.Entry<String, String>> proxyEntries = new LinkedList<Map.Entry<String, String>>();
        for (ObjectNamespace objectNamespace : this.proxies.keySet()) {
            String name = objectNamespace.getObjectName();
            String serviceName = objectNamespace.getServiceName();
            proxyEntries.add(new AbstractMap.SimpleEntry<String, String>(name, serviceName));
        }
        if (proxyEntries.isEmpty()) {
            return;
        }
        ClientMessage clientMessage = ClientCreateProxiesCodec.encodeRequest(proxyEntries);
        new ClientInvocation(this.client, clientMessage, null).invokeUrgent();
        this.createCachesOnCluster();
    }

    private void createCachesOnCluster() {
        ClientCacheProxyFactory proxyFactory = (ClientCacheProxyFactory)this.getClientProxyFactory("hz:impl:cacheService");
        if (proxyFactory != null) {
            proxyFactory.recreateCachesOnCluster();
        }
    }

    public boolean removeDistributedObjectListener(@Nonnull UUID id) {
        return this.client.getListenerService().deregisterListener(id);
    }

    private <T> T instantiateClientProxy(Class<T> proxyType, String serviceName, ClientContext context, String id) {
        try {
            try {
                Constructor<T> constructor = proxyType.getConstructor(CONSTRUCTOR_ARGUMENT_TYPES);
                return constructor.newInstance(serviceName, id, context);
            }
            catch (NoSuchMethodException e) {
                Constructor<T> constructor = proxyType.getConstructor(LEGACY_CONSTRUCTOR_ARGUMENT_TYPES);
                return constructor.newInstance(serviceName, id);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static class ClientProxyFuture
    implements ForkJoinPool.ManagedBlocker {
        volatile Object proxy;

        private ClientProxyFuture() {
        }

        ClientProxy get() {
            try {
                ForkJoinPool.managedBlock(this);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Object object = this.proxy;
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                throw ExceptionUtil.rethrow(throwable);
            }
            return (ClientProxy)this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(Object o) {
            if (o == null) {
                throw new IllegalArgumentException();
            }
            ClientProxyFuture clientProxyFuture = this;
            synchronized (clientProxyFuture) {
                this.proxy = o;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean block() throws InterruptedException {
            if (Thread.currentThread().isInterrupted() || this.isReleasable()) {
                return true;
            }
            boolean interrupted = false;
            ClientProxyFuture clientProxyFuture = this;
            synchronized (clientProxyFuture) {
                while (this.proxy == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
                return true;
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.proxy != null;
        }
    }

    private final class DistributedObjectEventHandler
    extends ClientAddDistributedObjectListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final DistributedObjectListener listener;
        private ProxyManager proxyManager;

        private DistributedObjectEventHandler(@Nonnull DistributedObjectListener listener, ProxyManager proxyManager2) {
            this.listener = listener;
            this.proxyManager = proxyManager2;
        }

        @Override
        public void handleDistributedObjectEvent(String name, String serviceName, String eventTypeName, UUID source) {
            DistributedObjectNamespace ns = new DistributedObjectNamespace(serviceName, name);
            ClientProxyFuture future = (ClientProxyFuture)ProxyManager.this.proxies.get(ns);
            ClientProxy proxy = future == null ? null : future.get();
            DistributedObjectEvent.EventType eventType = DistributedObjectEvent.EventType.valueOf(eventTypeName);
            LazyDistributedObjectEvent event = new LazyDistributedObjectEvent(eventType, serviceName, name, proxy, source, this.proxyManager);
            if (DistributedObjectEvent.EventType.CREATED.equals((Object)eventType)) {
                this.listener.distributedObjectCreated(event);
            } else if (DistributedObjectEvent.EventType.DESTROYED.equals((Object)eventType)) {
                this.listener.distributedObjectDestroyed(event);
            }
        }
    }

    private static final class DistributeObjectListenerMessageCodec
    implements ListenerMessageCodec {
        private DistributeObjectListenerMessageCodec() {
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return ClientAddDistributedObjectListenerCodec.encodeRequest(localOnly);
        }

        @Override
        public UUID decodeAddResponse(ClientMessage clientMessage) {
            return ClientAddDistributedObjectListenerCodec.decodeResponse(clientMessage);
        }

        @Override
        public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
            return ClientRemoveDistributedObjectListenerCodec.encodeRequest(realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return ClientRemoveDistributedObjectListenerCodec.decodeResponse(clientMessage);
        }
    }
}

