/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OfficeDescriptor {
    private static final String LIBRE_OFFICE = "LibreOffice";
    private static final String OPEN_OFFICE = "OpenOffice";
    private String product = "???";
    private boolean useLongOptionNameGnuStyle;

    private OfficeDescriptor() {
    }

    public static @NonNull OfficeDescriptor fromExecutablePath(@NonNull String path) {
        OfficeDescriptor desc = new OfficeDescriptor();
        String lowerPath = path.toLowerCase(Locale.ROOT);
        if (lowerPath.contains(LIBRE_OFFICE.toLowerCase(Locale.ROOT))) {
            desc.product = LIBRE_OFFICE;
            desc.useLongOptionNameGnuStyle = true;
        } else if (lowerPath.contains(OPEN_OFFICE.toLowerCase(Locale.ROOT))) {
            desc.product = OPEN_OFFICE;
            desc.useLongOptionNameGnuStyle = false;
        }
        return desc;
    }

    public @NonNull String getProduct() {
        return this.product;
    }

    public boolean useLongOptionNameGnuStyle() {
        return this.useLongOptionNameGnuStyle;
    }

    public @NonNull String toString() {
        return String.format("Product: %s - useLongOptionNameGnuStyle: %s", this.getProduct(), this.useLongOptionNameGnuStyle());
    }
}

