/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.record;

import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.room.RoomResourceReference;
import org.apache.openmeetings.web.user.record.Mp4RecordingResourceReference;
import org.apache.openmeetings.web.user.record.PngRecordingResourceReference;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.media.Source;
import org.apache.wicket.markup.html.media.video.Video;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class VideoPlayer
extends Panel {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer container = new WebMarkupContainer("container");
    private final Mp4RecordingResourceReference mp4RecRes = new Mp4RecordingResourceReference();
    private final PngRecordingResourceReference posterRecRes = new PngRecordingResourceReference();
    private final RoomResourceReference mp4FileRes = new RoomResourceReference();
    private final RoomResourceReference posterFileRes = new RoomResourceReference();
    private final Video player = new Video("player"){
        private static final long serialVersionUID = 1L;

        public boolean isAutoplay() {
            return false;
        }

        public boolean hasControls() {
            return true;
        }
    };
    private final Source mp4Rec = new Source("mp4", (ResourceReference)this.mp4RecRes);
    private final Source mp4File = new Source("mp4", (ResourceReference)this.mp4FileRes);

    public VideoPlayer(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        this.add(new Component[]{this.container.setOutputMarkupPlaceholderTag(true)});
        this.mp4Rec.setDisplayType(true);
        this.mp4Rec.setType("video/mp4");
        this.mp4File.setDisplayType(true);
        this.mp4File.setType("video/mp4");
        this.player.add(new Component[]{this.mp4Rec});
        this.container.add(new Component[]{this.player});
        this.update(null, null);
    }

    public VideoPlayer update(AjaxRequestTarget target, BaseFileItem r) {
        boolean videoExists;
        boolean bl = videoExists = r != null && r.exists();
        if (videoExists) {
            PageParameters pp = new PageParameters();
            if (r instanceof Recording) {
                pp.add("id", (Object)r.getId());
                this.mp4Rec.setPageParameters(pp);
                this.player.replace((Component)this.mp4Rec);
                this.player.setPoster((ResourceReference)this.posterRecRes, pp);
            } else {
                pp.add("id", (Object)r.getId()).add("uid", (Object)((MainPanel)((Object)this.findParent(MainPanel.class))).getClient().getUid());
                this.mp4File.setPageParameters(pp);
                this.player.replace((Component)this.mp4File);
                this.player.setPoster((ResourceReference)this.posterFileRes, new PageParameters(pp).add("preview", (Object)true));
            }
        }
        this.container.setVisible(videoExists);
        if (target != null) {
            target.add(new Component[]{this.container});
        }
        return this;
    }
}

