/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.RenderingHints;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.Sides;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="printpdf", header={"Prints a PDF document"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class PrintPDF
implements Callable<Integer> {
    private final PrintStream SYSERR;
    @CommandLine.Option(names={"-password"}, description={"the password to decrypt the document."}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-silentPrint"}, description={"print without printer dialog box."})
    private boolean silentPrint;
    @CommandLine.Option(names={"-printerName"}, description={"print to specific printer."})
    private String printerName;
    @CommandLine.Option(names={"-orientation"}, description={"print using orientation [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})."})
    private Orientation orientation = Orientation.AUTO;
    @CommandLine.Option(names={"-duplex"}, description={"print using duplex [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})."})
    private Duplex duplex = Duplex.DOCUMENT;
    @CommandLine.Option(names={"-tray"}, description={"print using tray."})
    private String tray;
    @CommandLine.Option(names={"-mediaSize"}, description={"print using media size name."})
    private String mediaSize;
    @CommandLine.Option(names={"-border"}, description={"print with border."})
    private boolean border;
    @CommandLine.Option(names={"-dpi"}, description={"render into intermediate image with specific dpi and then print. Use \"-1\" for the dpi of the printer."})
    private int dpi;
    @CommandLine.Option(names={"-noCenter"}, description={"align top-left (default: center on page)."})
    private boolean noCenter = false;
    @CommandLine.Option(names={"-noColorOpt"}, description={"disable color optimizations (useful when printing barcodes)."})
    private boolean noColorOpt;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF files to print."}, required=true)
    private File infile;

    public PrintPDF() {
        this.SYSERR = System.err;
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new PrintPDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        RenderingHints renderingHints = null;
        if (this.noColorOpt) {
            renderingHints = new RenderingHints(null);
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        try (PDDocument document = Loader.loadPDF(this.infile, this.password);){
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canPrint()) {
                throw new IOException("You do not have permission to print");
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(this.infile.getName());
            if (this.printerName != null) {
                PrintService[] printServices = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (PrintService printService : printServices) {
                    if (!printService.getName().equalsIgnoreCase(this.printerName)) continue;
                    printJob.setPrintService(printService);
                    printerFound = true;
                    break;
                }
                if (!printerFound) {
                    this.SYSERR.println("printer '" + this.printerName + "' not found, using default '" + printJob.getPrintService().getName() + "'");
                    this.showAvailablePrinters();
                }
            }
            PrintService printService = printJob.getPrintService();
            PrintRequestAttributeSet pras = this.createPrintRequestAttributeSet(document);
            if (this.tray != null) {
                boolean found = false;
                for (MediaTray mediaTray : PrintPDF.getTraysFromPrintService(printService)) {
                    if (!this.tray.equals(mediaTray.toString())) continue;
                    pras.add(this.toPossibleAlternateMedia(mediaTray));
                    found = true;
                    break;
                }
                if (!found) {
                    this.SYSERR.println("Tray '" + this.tray + "' not supported, ignored. Valid values: " + PrintPDF.getTraysFromPrintService(printService));
                }
            }
            if (this.mediaSize != null) {
                boolean found = false;
                for (MediaSizeName mediaSizeName : PrintPDF.getMediaSizesFromPrintService(printService)) {
                    if (!this.mediaSize.equals(mediaSizeName.toString())) continue;
                    pras.add(mediaSizeName);
                    found = true;
                    break;
                }
                if (!found) {
                    this.SYSERR.println("media size '" + this.mediaSize + "' not supported, ignored. Valid values: " + PrintPDF.getMediaSizesFromPrintService(printService));
                }
            }
            PDFPageable pageable = new PDFPageable(document, this.orientation, this.border, this.dpi, !this.noCenter);
            pageable.setRenderingHints(renderingHints);
            printJob.setPageable(pageable);
            if (this.silentPrint || printJob.printDialog(pras)) {
                printJob.print(pras);
            }
        }
        catch (PrinterException | IOException ex) {
            this.SYSERR.println("Error printing document [" + ex.getClass().getSimpleName() + "]: " + ex.getMessage());
            return 4;
        }
        return 0;
    }

    private static List<MediaTray> getTraysFromPrintService(PrintService printService) {
        Media[] medias = (Media[])printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (medias == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaTray> trayList = new ArrayList<MediaTray>();
        for (Media media : medias) {
            if (!(media instanceof MediaTray)) continue;
            trayList.add((MediaTray)media);
        }
        return trayList;
    }

    private static List<MediaSizeName> getMediaSizesFromPrintService(PrintService printService) {
        Media[] medias = (Media[])printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (medias == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaSizeName> sizeList = new ArrayList<MediaSizeName>();
        for (Media media : medias) {
            if (!(media instanceof MediaSizeName)) continue;
            sizeList.add((MediaSizeName)media);
        }
        return sizeList;
    }

    private PrintRequestAttributeSet createPrintRequestAttributeSet(PDDocument document) {
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        if (this.duplex.toSides() == null) {
            PDViewerPreferences vp = document.getDocumentCatalog().getViewerPreferences();
            if (vp != null && vp.getDuplex() != null) {
                String dp = vp.getDuplex();
                if (PDViewerPreferences.DUPLEX.DuplexFlipLongEdge.toString().equals(dp)) {
                    pras.add(Sides.TWO_SIDED_LONG_EDGE);
                } else if (PDViewerPreferences.DUPLEX.DuplexFlipShortEdge.toString().equals(dp)) {
                    pras.add(Sides.TWO_SIDED_SHORT_EDGE);
                } else if (PDViewerPreferences.DUPLEX.Simplex.toString().equals(dp)) {
                    pras.add(Sides.ONE_SIDED);
                }
            }
        } else {
            pras.add(this.duplex.toSides());
        }
        return pras;
    }

    private Attribute toPossibleAlternateMedia(MediaTray mediaTray) {
        if (this.mediaSize == null) {
            return mediaTray;
        }
        String version = System.getProperty("java.specification.version");
        if (!"1.8".equals(version)) {
            return mediaTray;
        }
        try {
            Class<?> clazz = Class.forName("sun.print.SunAlternateMedia");
            Constructor<?> ctor = clazz.getDeclaredConstructor(Media.class);
            return (Attribute)ctor.newInstance(mediaTray);
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            return mediaTray;
        }
    }

    @CommandLine.Command(name="listPrinters", description={"list available printers"}, helpCommand=true)
    private void showAvailablePrinters() {
        PrintService[] printServices;
        this.SYSERR.println("Available printer names:");
        for (PrintService printService : printServices = PrinterJob.lookupPrintServices()) {
            this.SYSERR.println("    " + printService.getName());
            this.SYSERR.println("        Sizes: " + PrintPDF.getMediaSizesFromPrintService(printService));
            this.SYSERR.println("        Trays: " + PrintPDF.getTraysFromPrintService(printService));
        }
    }

    static enum Duplex {
        SIMPLEX(0),
        DUPLEX(1),
        TUMBLE(2),
        DOCUMENT(3);

        int num;

        private Duplex(int p) {
            this.num = p;
        }

        Sides toSides() {
            switch (this.num) {
                case 0: {
                    return Sides.ONE_SIDED;
                }
                case 1: {
                    return Sides.DUPLEX;
                }
                case 2: {
                    return Sides.TUMBLE;
                }
            }
            return null;
        }
    }
}

