/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.

using System;
using System.Collections.Generic;
using NLog;
using org.apache.plc4net.api.value;
using org.apache.plc4net.spi.generation;
using org.apache.plc4net.spi.model.values;
using org.apache.plc4net.types;

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public class KnxDatapoint
    {

        private static readonly ILogger Logger = LogManager.GetCurrentClassLogger();

        public static IPlcValue StaticParse(ReadBuffer readBuffer, KnxDatapointType datapointType)
        {
if( datapointType == KnxDatapointType.BOOL ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.BYTE ) { // BYTE

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcBYTE(value);
            } if( datapointType == KnxDatapointType.WORD ) { // WORD

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcWORD(value);
            } if( datapointType == KnxDatapointType.DWORD ) { // DWORD

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcDWORD(value);
            } if( datapointType == KnxDatapointType.LWORD ) { // LWORD

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUlong("", 64);

                return new PlcLWORD(value);
            } if( datapointType == KnxDatapointType.USINT ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.SINT ) { // SINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadSbyte("", 8);

                return new PlcSINT(value);
            } if( datapointType == KnxDatapointType.UINT ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.INT ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.UDINT ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DINT ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.ULINT ) { // ULINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUlong("", 64);

                return new PlcULINT(value);
            } if( datapointType == KnxDatapointType.LINT ) { // LINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadLong("", 64);

                return new PlcLINT(value);
            } if( datapointType == KnxDatapointType.REAL ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.LREAL ) { // LREAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadDouble("", 64);

                return new PlcLREAL(value);
            } if( datapointType == KnxDatapointType.CHAR ) { // CHAR

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 8, System.Text.Encoding.GetEncoding("UTF-8"));

                return new PlcCHAR(Convert.ToChar(value));
            } if( datapointType == KnxDatapointType.WCHAR ) { // WCHAR

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 16, System.Text.Encoding.GetEncoding("UTF-16"));

                return new PlcWCHAR(Convert.ToChar(value));
            } if( datapointType == KnxDatapointType.TIME ) { // TIME

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (milliseconds)
                var milliseconds = readBuffer.ReadUint("", 32);

            } if( datapointType == KnxDatapointType.LTIME ) { // LTIME

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (nanoseconds)
                var nanoseconds = readBuffer.ReadUlong("", 64);

            } if( datapointType == KnxDatapointType.DATE ) { // DATE

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (secondsSinceEpoch)
                var secondsSinceEpoch = readBuffer.ReadUint("", 32);

            } if( datapointType == KnxDatapointType.TIME_OF_DAY ) { // TIME_OF_DAY

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (millisecondsSinceMidnight)
                var millisecondsSinceMidnight = readBuffer.ReadUint("", 32);

            } if( datapointType == KnxDatapointType.TOD ) { // TIME_OF_DAY

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (millisecondsSinceMidnight)
                var millisecondsSinceMidnight = readBuffer.ReadUint("", 32);

            } if( datapointType == KnxDatapointType.DATE_AND_TIME ) { // DATE_AND_TIME

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (year)
                var year = readBuffer.ReadUshort("", 16);

                // Simple Field (month)
                var month = readBuffer.ReadByte("", 8);

                // Simple Field (day)
                var day = readBuffer.ReadByte("", 8);

                // Simple Field (dayOfWeek)
                var dayOfWeek = readBuffer.ReadByte("", 8);

                // Simple Field (hour)
                var hour = readBuffer.ReadByte("", 8);

                // Simple Field (minutes)
                var minutes = readBuffer.ReadByte("", 8);

                // Simple Field (seconds)
                var seconds = readBuffer.ReadByte("", 8);

                // Simple Field (nanoseconds)
                var nanoseconds = readBuffer.ReadUint("", 32);

                var value = new DateTime(year, (month == 0) ? 1 : month, (day == 0) ? 1 : day, hour, minutes, seconds, 0);
                return new PlcDATE_AND_TIME(value);
            } if( datapointType == KnxDatapointType.DT ) { // DATE_AND_TIME

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (year)
                var year = readBuffer.ReadUshort("", 16);

                // Simple Field (month)
                var month = readBuffer.ReadByte("", 8);

                // Simple Field (day)
                var day = readBuffer.ReadByte("", 8);

                // Simple Field (dayOfWeek)
                var dayOfWeek = readBuffer.ReadByte("", 8);

                // Simple Field (hour)
                var hour = readBuffer.ReadByte("", 8);

                // Simple Field (minutes)
                var minutes = readBuffer.ReadByte("", 8);

                // Simple Field (seconds)
                var seconds = readBuffer.ReadByte("", 8);

                // Simple Field (nanoseconds)
                var nanoseconds = readBuffer.ReadUint("", 32);

                var value = new DateTime(year, (month == 0) ? 1 : month, (day == 0) ? 1 : day, hour, minutes, seconds, 0);
                return new PlcDATE_AND_TIME(value);
            } if( datapointType == KnxDatapointType.DPT_Switch ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Bool ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Enable ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Ramp ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Alarm ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_BinaryValue ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Step ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_UpDown ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_OpenClose ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Start ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_State ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Invert ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_DimSendStyle ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_InputSource ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Reset ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Ack ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Trigger ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Occupancy ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Window_Door ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_LogicalFunction ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Scene_AB ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_ShutterBlinds_Mode ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_DayNight ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Heat_Cool ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_Switch_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (on)
                var on = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Bool_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (valueTrue)
                var valueTrue = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Enable_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (enable)
                var enable = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Ramp_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (ramp)
                var ramp = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Alarm_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (alarm)
                var alarm = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_BinaryValue_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (high)
                var high = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Step_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (increase)
                var increase = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Direction1_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (down)
                var down = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Direction2_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (close)
                var close = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Start_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (start)
                var start = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_State_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (active)
                var active = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Invert_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (control)
                var control = readBuffer.ReadBit("");

                // Simple Field (inverted)
                var inverted = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Control_Dimming ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (increase)
                var increase = readBuffer.ReadBit("");

                // Simple Field (stepcode)
                var stepcode = readBuffer.ReadByte("", 3);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Control_Blinds ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (down)
                var down = readBuffer.ReadBit("");

                // Simple Field (stepcode)
                var stepcode = readBuffer.ReadByte("", 3);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Char_ASCII ) { // STRING

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 8, System.Text.Encoding.GetEncoding("ASCII"));

                return new PlcSTRING(value);
            } if( datapointType == KnxDatapointType.DPT_Char_8859_1 ) { // STRING

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 8, System.Text.Encoding.GetEncoding("ISO-8859-1"));

                return new PlcSTRING(value);
            } if( datapointType == KnxDatapointType.DPT_Scaling ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Angle ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Percent_U8 ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_DecimalFactor ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Tariff ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Value_1_Ucount ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_FanStage ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Percent_V8 ) { // SINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadSbyte("", 8);

                return new PlcSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Value_1_Count ) { // SINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadSbyte("", 8);

                return new PlcSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Status_Mode3 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (statusA)
                var statusA = readBuffer.ReadBit("");

                // Simple Field (statusB)
                var statusB = readBuffer.ReadBit("");

                // Simple Field (statusC)
                var statusC = readBuffer.ReadBit("");

                // Simple Field (statusD)
                var statusD = readBuffer.ReadBit("");

                // Simple Field (statusE)
                var statusE = readBuffer.ReadBit("");

                // Simple Field (mode)
                var mode = readBuffer.ReadByte("", 3);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Value_2_Ucount ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_TimePeriodMsec ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_TimePeriod10Msec ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_TimePeriod100Msec ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_TimePeriodSec ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_TimePeriodMin ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_TimePeriodHrs ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_PropDataType ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_Length_mm ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_UElCurrentmA ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_Brightness ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_Absolute_Colour_Temperature ) { // UINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUshort("", 16);

                return new PlcUINT(value);
            } if( datapointType == KnxDatapointType.DPT_Value_2_Count ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaTimeMsec ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaTime10Msec ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaTime100Msec ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaTimeSec ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaTimeMin ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaTimeHrs ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_Percent_V16 ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_Rotation_Angle ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_Length_m ) { // INT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadShort("", 16);

                return new PlcINT(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Temp ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Tempd ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Tempa ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Lux ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Wsp ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Pres ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Humidity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_AirQuality ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_AirFlow ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Time1 ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Time2 ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Volt ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Curr ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_PowerDensity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_KelvinPerPercent ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Power ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Volume_Flow ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Rain_Amount ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Temp_F ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Wsp_kmh ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Absolute_Humidity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Concentration_ygm3 ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Coefficient ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_TimeOfDay ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (day)
                var day = readBuffer.ReadByte("", 3);

                // Simple Field (hour)
                var hour = readBuffer.ReadByte("", 5);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (minutes)
                var minutes = readBuffer.ReadByte("", 6);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (seconds)
                var seconds = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Date ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (dayOfMonth)
                var dayOfMonth = readBuffer.ReadByte("", 5);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (month)
                var month = readBuffer.ReadByte("", 4);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (year)
                var year = readBuffer.ReadByte("", 7);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Value_4_Ucount ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DPT_LongTimePeriod_Sec ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DPT_LongTimePeriod_Min ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DPT_LongTimePeriod_Hrs ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DPT_VolumeLiquid_Litre ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DPT_Volume_m_3 ) { // UDINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadUint("", 32);

                return new PlcUDINT(value);
            } if( datapointType == KnxDatapointType.DPT_Value_4_Count ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_FlowRate_m3h ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ActiveEnergy ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ApparentEnergy ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ReactiveEnergy ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ActiveEnergy_kWh ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ApparentEnergy_kVAh ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ReactiveEnergy_kVARh ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_ActiveEnergy_MWh ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_LongDeltaTimeSec ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaVolumeLiquid_Litre ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_DeltaVolume_m_3 ) { // DINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadInt("", 32);

                return new PlcDINT(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Acceleration ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Acceleration_Angular ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Activation_Energy ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Activity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Mol ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Amplitude ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_AngleRad ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_AngleDeg ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Angular_Momentum ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Angular_Velocity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Area ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Capacitance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Charge_DensitySurface ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Charge_DensityVolume ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Compressibility ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Conductance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electrical_Conductivity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Density ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_Charge ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_Current ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_CurrentDensity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_DipoleMoment ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_Displacement ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_FieldStrength ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_Flux ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_FluxDensity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_Polarization ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_Potential ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electric_PotentialDifference ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_ElectromagneticMoment ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Electromotive_Force ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Energy ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Force ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Frequency ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Angular_Frequency ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Heat_Capacity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Heat_FlowRate ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Heat_Quantity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Impedance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Length ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Light_Quantity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Luminance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Luminous_Flux ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Luminous_Intensity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_FieldStrength ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_Flux ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_FluxDensity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_Moment ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_Polarization ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Magnetization ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_MagnetomotiveForce ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Mass ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_MassFlux ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Momentum ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Phase_AngleRad ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Phase_AngleDeg ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Power ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Power_Factor ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Pressure ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Reactance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Resistance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Resistivity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_SelfInductance ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_SolidAngle ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Sound_Intensity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Speed ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Stress ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Surface_Tension ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Common_Temperature ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Absolute_Temperature ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_TemperatureDifference ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Thermal_Capacity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Thermal_Conductivity ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_ThermoelectricPower ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Time ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Torque ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Volume ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Volume_Flux ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Weight ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_Work ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Value_ApparentPower ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 32);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Volume_Flux_Meter ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Volume_Flux_ls ) { // REAL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadFloat("", 16);

                return new PlcREAL(value);
            } if( datapointType == KnxDatapointType.DPT_Access_Data ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (hurz)
                var hurz = readBuffer.ReadByte("", 4);

                // Simple Field (value1)
                var value1 = readBuffer.ReadByte("", 4);

                // Simple Field (value2)
                var value2 = readBuffer.ReadByte("", 4);

                // Simple Field (value3)
                var value3 = readBuffer.ReadByte("", 4);

                // Simple Field (value4)
                var value4 = readBuffer.ReadByte("", 4);

                // Simple Field (value5)
                var value5 = readBuffer.ReadByte("", 4);

                // Simple Field (detectionError)
                var detectionError = readBuffer.ReadBit("");

                // Simple Field (permission)
                var permission = readBuffer.ReadBit("");

                // Simple Field (readDirection)
                var readDirection = readBuffer.ReadBit("");

                // Simple Field (encryptionOfAccessInformation)
                var encryptionOfAccessInformation = readBuffer.ReadBit("");

                // Simple Field (indexOfAccessIdentificationCode)
                var indexOfAccessIdentificationCode = readBuffer.ReadByte("", 4);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_String_ASCII ) { // STRING

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 112, System.Text.Encoding.GetEncoding("ASCII"));

                return new PlcSTRING(value);
            } if( datapointType == KnxDatapointType.DPT_String_8859_1 ) { // STRING

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 112, System.Text.Encoding.GetEncoding("ISO-8859-1"));

                return new PlcSTRING(value);
            } if( datapointType == KnxDatapointType.DPT_SceneNumber ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 6);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SceneControl ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
                var learnTheSceneCorrespondingToTheFieldSceneNumber = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (sceneNumber)
                var sceneNumber = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_DateTime ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (year)
                var year = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (month)
                var month = readBuffer.ReadByte("", 4);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (dayofmonth)
                var dayofmonth = readBuffer.ReadByte("", 5);

                // Simple Field (dayofweek)
                var dayofweek = readBuffer.ReadByte("", 3);

                // Simple Field (hourofday)
                var hourofday = readBuffer.ReadByte("", 5);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (minutes)
                var minutes = readBuffer.ReadByte("", 6);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (seconds)
                var seconds = readBuffer.ReadByte("", 6);

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                // Simple Field (workingDay)
                var workingDay = readBuffer.ReadBit("");

                // Simple Field (noWd)
                var noWd = readBuffer.ReadBit("");

                // Simple Field (noYear)
                var noYear = readBuffer.ReadBit("");

                // Simple Field (noDate)
                var noDate = readBuffer.ReadBit("");

                // Simple Field (noDayOfWeek)
                var noDayOfWeek = readBuffer.ReadBit("");

                // Simple Field (noTime)
                var noTime = readBuffer.ReadBit("");

                // Simple Field (standardSummerTime)
                var standardSummerTime = readBuffer.ReadBit("");

                // Simple Field (qualityOfClock)
                var qualityOfClock = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_SCLOMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_BuildingMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_OccMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Priority ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_LightApplicationMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ApplicationArea ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_AlarmClassType ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_PSUMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ErrorClass_System ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ErrorClass_HVAC ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Time_Delay ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Beaufort_Wind_Force_Scale ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SensorSelect ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ActuatorConnectType ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Cloud_Cover ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_PowerReturnMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_FuelType ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_BurnerType ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_HVACMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_DHWMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_LoadPriority ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_HVACContrMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_HVACEmergMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ChangeoverMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ValveMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_DamperMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_HeaterMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_FanMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_MasterSlaveMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_StatusRoomSetp ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Metering_DeviceType ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_HumDehumMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_EnableHCStage ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_ADAType ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_BackupMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_StartSynchronization ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Behaviour_Lock_Unlock ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_DALI_Fade_Time ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_BlinkingMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_LightControlMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SwitchPBModel ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_PBAction ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_DimmPBModel ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SwitchOnMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_LoadTypeSet ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_LoadTypeDetected ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Converter_Test_Control ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Converter_Control ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SABExcept_Behaviour ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SABBehaviour_Lock_Unlock ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_SSSBMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_BlindsControlMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_CommMode ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_AddInfoTypes ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_RF_ModeSelect ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_RF_FilterSelect ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 8);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_StatusGen ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
                var alarmStatusOfCorrespondingDatapointIsNotAcknowledged = readBuffer.ReadBit("");

                // Simple Field (correspondingDatapointIsInAlarm)
                var correspondingDatapointIsInAlarm = readBuffer.ReadBit("");

                // Simple Field (correspondingDatapointMainValueIsOverridden)
                var correspondingDatapointMainValueIsOverridden = readBuffer.ReadBit("");

                // Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
                var correspondingDatapointMainValueIsCorruptedDueToFailure = readBuffer.ReadBit("");

                // Simple Field (correspondingDatapointValueIsOutOfService)
                var correspondingDatapointValueIsOutOfService = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Device_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (verifyModeIsOn)
                var verifyModeIsOn = readBuffer.ReadBit("");

                // Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
                var aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived = readBuffer.ReadBit("");

                // Simple Field (theUserApplicationIsStopped)
                var theUserApplicationIsStopped = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_ForceSign ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (roomhmax)
                var roomhmax = readBuffer.ReadBit("");

                // Simple Field (roomhconf)
                var roomhconf = readBuffer.ReadBit("");

                // Simple Field (dhwlegio)
                var dhwlegio = readBuffer.ReadBit("");

                // Simple Field (dhwnorm)
                var dhwnorm = readBuffer.ReadBit("");

                // Simple Field (overrun)
                var overrun = readBuffer.ReadBit("");

                // Simple Field (oversupply)
                var oversupply = readBuffer.ReadBit("");

                // Simple Field (protection)
                var protection = readBuffer.ReadBit("");

                // Simple Field (forcerequest)
                var forcerequest = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_ForceSignCool ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_StatusRHC ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (summermode)
                var summermode = readBuffer.ReadBit("");

                // Simple Field (statusstopoptim)
                var statusstopoptim = readBuffer.ReadBit("");

                // Simple Field (statusstartoptim)
                var statusstartoptim = readBuffer.ReadBit("");

                // Simple Field (statusmorningboost)
                var statusmorningboost = readBuffer.ReadBit("");

                // Simple Field (tempreturnlimit)
                var tempreturnlimit = readBuffer.ReadBit("");

                // Simple Field (tempflowlimit)
                var tempflowlimit = readBuffer.ReadBit("");

                // Simple Field (satuseco)
                var satuseco = readBuffer.ReadBit("");

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_StatusSDHWC ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (solarloadsufficient)
                var solarloadsufficient = readBuffer.ReadBit("");

                // Simple Field (sdhwloadactive)
                var sdhwloadactive = readBuffer.ReadBit("");

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_FuelTypeSet ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (solidstate)
                var solidstate = readBuffer.ReadBit("");

                // Simple Field (gas)
                var gas = readBuffer.ReadBit("");

                // Simple Field (oil)
                var oil = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_StatusRCC ) { // BOOL

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadBit("");

                return new PlcBOOL(value);
            } if( datapointType == KnxDatapointType.DPT_StatusAHU ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cool)
                var cool = readBuffer.ReadBit("");

                // Simple Field (heat)
                var heat = readBuffer.ReadBit("");

                // Simple Field (fanactive)
                var fanactive = readBuffer.ReadBit("");

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_CombinedStatus_RTSM ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (statusOfHvacModeUser)
                var statusOfHvacModeUser = readBuffer.ReadBit("");

                // Simple Field (statusOfComfortProlongationUser)
                var statusOfComfortProlongationUser = readBuffer.ReadBit("");

                // Simple Field (effectiveValueOfTheComfortPushButton)
                var effectiveValueOfTheComfortPushButton = readBuffer.ReadBit("");

                // Simple Field (effectiveValueOfThePresenceStatus)
                var effectiveValueOfThePresenceStatus = readBuffer.ReadBit("");

                // Simple Field (effectiveValueOfTheWindowStatus)
                var effectiveValueOfTheWindowStatus = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_LightActuatorErrorInfo ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (overheat)
                var overheat = readBuffer.ReadBit("");

                // Simple Field (lampfailure)
                var lampfailure = readBuffer.ReadBit("");

                // Simple Field (defectiveload)
                var defectiveload = readBuffer.ReadBit("");

                // Simple Field (underload)
                var underload = readBuffer.ReadBit("");

                // Simple Field (overcurrent)
                var overcurrent = readBuffer.ReadBit("");

                // Simple Field (undervoltage)
                var undervoltage = readBuffer.ReadBit("");

                // Simple Field (loaddetectionerror)
                var loaddetectionerror = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_RF_ModeInfo ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (bibatSlave)
                var bibatSlave = readBuffer.ReadBit("");

                // Simple Field (bibatMaster)
                var bibatMaster = readBuffer.ReadBit("");

                // Simple Field (asynchronous)
                var asynchronous = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_RF_FilterInfo ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (doa)
                var doa = readBuffer.ReadBit("");

                // Simple Field (knxSn)
                var knxSn = readBuffer.ReadBit("");

                // Simple Field (doaAndKnxSn)
                var doaAndKnxSn = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Channel_Activation_8 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (activationStateOfChannel1)
                var activationStateOfChannel1 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel2)
                var activationStateOfChannel2 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel3)
                var activationStateOfChannel3 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel4)
                var activationStateOfChannel4 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel5)
                var activationStateOfChannel5 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel6)
                var activationStateOfChannel6 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel7)
                var activationStateOfChannel7 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel8)
                var activationStateOfChannel8 = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_StatusDHWC ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (tempoptimshiftactive)
                var tempoptimshiftactive = readBuffer.ReadBit("");

                // Simple Field (solarenergysupport)
                var solarenergysupport = readBuffer.ReadBit("");

                // Simple Field (solarenergyonly)
                var solarenergyonly = readBuffer.ReadBit("");

                // Simple Field (otherenergysourceactive)
                var otherenergysourceactive = readBuffer.ReadBit("");

                // Simple Field (dhwpushactive)
                var dhwpushactive = readBuffer.ReadBit("");

                // Simple Field (legioprotactive)
                var legioprotactive = readBuffer.ReadBit("");

                // Simple Field (dhwloadactive)
                var dhwloadactive = readBuffer.ReadBit("");

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_StatusRHCC ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (overheatalarm)
                var overheatalarm = readBuffer.ReadBit("");

                // Simple Field (frostalarm)
                var frostalarm = readBuffer.ReadBit("");

                // Simple Field (dewpointstatus)
                var dewpointstatus = readBuffer.ReadBit("");

                // Simple Field (coolingdisabled)
                var coolingdisabled = readBuffer.ReadBit("");

                // Simple Field (statusprecool)
                var statusprecool = readBuffer.ReadBit("");

                // Simple Field (statusecoc)
                var statusecoc = readBuffer.ReadBit("");

                // Simple Field (heatcoolmode)
                var heatcoolmode = readBuffer.ReadBit("");

                // Simple Field (heatingdiabled)
                var heatingdiabled = readBuffer.ReadBit("");

                // Simple Field (statusstopoptim)
                var statusstopoptim = readBuffer.ReadBit("");

                // Simple Field (statusstartoptim)
                var statusstartoptim = readBuffer.ReadBit("");

                // Simple Field (statusmorningboosth)
                var statusmorningboosth = readBuffer.ReadBit("");

                // Simple Field (tempflowreturnlimit)
                var tempflowreturnlimit = readBuffer.ReadBit("");

                // Simple Field (tempflowlimit)
                var tempflowlimit = readBuffer.ReadBit("");

                // Simple Field (statusecoh)
                var statusecoh = readBuffer.ReadBit("");

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_CombinedStatus_HVA ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (calibrationMode)
                var calibrationMode = readBuffer.ReadBit("");

                // Simple Field (lockedPosition)
                var lockedPosition = readBuffer.ReadBit("");

                // Simple Field (forcedPosition)
                var forcedPosition = readBuffer.ReadBit("");

                // Simple Field (manuaOperationOverridden)
                var manuaOperationOverridden = readBuffer.ReadBit("");

                // Simple Field (serviceMode)
                var serviceMode = readBuffer.ReadBit("");

                // Simple Field (valveKick)
                var valveKick = readBuffer.ReadBit("");

                // Simple Field (overload)
                var overload = readBuffer.ReadBit("");

                // Simple Field (shortCircuit)
                var shortCircuit = readBuffer.ReadBit("");

                // Simple Field (currentValvePosition)
                var currentValvePosition = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_CombinedStatus_RTC ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 7);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (coolingModeEnabled)
                var coolingModeEnabled = readBuffer.ReadBit("");

                // Simple Field (heatingModeEnabled)
                var heatingModeEnabled = readBuffer.ReadBit("");

                // Simple Field (additionalHeatingCoolingStage2Stage)
                var additionalHeatingCoolingStage2Stage = readBuffer.ReadBit("");

                // Simple Field (controllerInactive)
                var controllerInactive = readBuffer.ReadBit("");

                // Simple Field (overheatAlarm)
                var overheatAlarm = readBuffer.ReadBit("");

                // Simple Field (frostAlarm)
                var frostAlarm = readBuffer.ReadBit("");

                // Simple Field (dewPointStatus)
                var dewPointStatus = readBuffer.ReadBit("");

                // Simple Field (activeMode)
                var activeMode = readBuffer.ReadBit("");

                // Simple Field (generalFailureInformation)
                var generalFailureInformation = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Media ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadUshort("", 10);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (knxIp)
                var knxIp = readBuffer.ReadBit("");

                // Simple Field (rf)
                var rf = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (pl110)
                var pl110 = readBuffer.ReadBit("");

                // Simple Field (tp1)
                var tp1 = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Channel_Activation_16 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (activationStateOfChannel1)
                var activationStateOfChannel1 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel2)
                var activationStateOfChannel2 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel3)
                var activationStateOfChannel3 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel4)
                var activationStateOfChannel4 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel5)
                var activationStateOfChannel5 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel6)
                var activationStateOfChannel6 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel7)
                var activationStateOfChannel7 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel8)
                var activationStateOfChannel8 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel9)
                var activationStateOfChannel9 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel10)
                var activationStateOfChannel10 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel11)
                var activationStateOfChannel11 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel12)
                var activationStateOfChannel12 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel13)
                var activationStateOfChannel13 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel14)
                var activationStateOfChannel14 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel15)
                var activationStateOfChannel15 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel16)
                var activationStateOfChannel16 = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_OnOffAction ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 2);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_Alarm_Reaction ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 2);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_UpDown_Action ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 2);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_HVAC_PB_Action ) { // USINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadByte("", 2);

                return new PlcUSINT(value);
            } if( datapointType == KnxDatapointType.DPT_DoubleNibble ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (busy)
                var busy = readBuffer.ReadByte("", 4);

                // Simple Field (nak)
                var nak = readBuffer.ReadByte("", 4);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_SceneInfo ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 1);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (sceneIsInactive)
                var sceneIsInactive = readBuffer.ReadBit("");

                // Simple Field (scenenumber)
                var scenenumber = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_CombinedInfoOnOff ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (maskBitInfoOnOffOutput16)
                var maskBitInfoOnOffOutput16 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput15)
                var maskBitInfoOnOffOutput15 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput14)
                var maskBitInfoOnOffOutput14 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput13)
                var maskBitInfoOnOffOutput13 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput12)
                var maskBitInfoOnOffOutput12 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput11)
                var maskBitInfoOnOffOutput11 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput10)
                var maskBitInfoOnOffOutput10 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput9)
                var maskBitInfoOnOffOutput9 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput8)
                var maskBitInfoOnOffOutput8 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput7)
                var maskBitInfoOnOffOutput7 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput6)
                var maskBitInfoOnOffOutput6 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput5)
                var maskBitInfoOnOffOutput5 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput4)
                var maskBitInfoOnOffOutput4 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput3)
                var maskBitInfoOnOffOutput3 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput2)
                var maskBitInfoOnOffOutput2 = readBuffer.ReadBit("");

                // Simple Field (maskBitInfoOnOffOutput1)
                var maskBitInfoOnOffOutput1 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput16)
                var infoOnOffOutput16 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput15)
                var infoOnOffOutput15 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput14)
                var infoOnOffOutput14 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput13)
                var infoOnOffOutput13 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput12)
                var infoOnOffOutput12 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput11)
                var infoOnOffOutput11 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput10)
                var infoOnOffOutput10 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput9)
                var infoOnOffOutput9 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput8)
                var infoOnOffOutput8 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput7)
                var infoOnOffOutput7 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput6)
                var infoOnOffOutput6 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput5)
                var infoOnOffOutput5 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput4)
                var infoOnOffOutput4 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput3)
                var infoOnOffOutput3 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput2)
                var infoOnOffOutput2 = readBuffer.ReadBit("");

                // Simple Field (infoOnOffOutput1)
                var infoOnOffOutput1 = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_ActiveEnergy_V64 ) { // LINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadLong("", 64);

                return new PlcLINT(value);
            } if( datapointType == KnxDatapointType.DPT_ApparentEnergy_V64 ) { // LINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadLong("", 64);

                return new PlcLINT(value);
            } if( datapointType == KnxDatapointType.DPT_ReactiveEnergy_V64 ) { // LINT

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadLong("", 64);

                return new PlcLINT(value);
            } if( datapointType == KnxDatapointType.DPT_Channel_Activation_24 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (activationStateOfChannel1)
                var activationStateOfChannel1 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel2)
                var activationStateOfChannel2 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel3)
                var activationStateOfChannel3 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel4)
                var activationStateOfChannel4 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel5)
                var activationStateOfChannel5 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel6)
                var activationStateOfChannel6 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel7)
                var activationStateOfChannel7 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel8)
                var activationStateOfChannel8 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel9)
                var activationStateOfChannel9 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel10)
                var activationStateOfChannel10 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel11)
                var activationStateOfChannel11 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel12)
                var activationStateOfChannel12 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel13)
                var activationStateOfChannel13 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel14)
                var activationStateOfChannel14 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel15)
                var activationStateOfChannel15 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel16)
                var activationStateOfChannel16 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel17)
                var activationStateOfChannel17 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel18)
                var activationStateOfChannel18 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel19)
                var activationStateOfChannel19 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel20)
                var activationStateOfChannel20 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel21)
                var activationStateOfChannel21 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel22)
                var activationStateOfChannel22 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel23)
                var activationStateOfChannel23 = readBuffer.ReadBit("");

                // Simple Field (activationStateOfChannel24)
                var activationStateOfChannel24 = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_HVACModeNext ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (delayTimeMin)
                var delayTimeMin = readBuffer.ReadUshort("", 16);

                // Simple Field (hvacMode)
                var hvacMode = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_DHWModeNext ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (delayTimeMin)
                var delayTimeMin = readBuffer.ReadUshort("", 16);

                // Simple Field (dhwMode)
                var dhwMode = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_OccModeNext ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (delayTimeMin)
                var delayTimeMin = readBuffer.ReadUshort("", 16);

                // Simple Field (occupancyMode)
                var occupancyMode = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_BuildingModeNext ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (delayTimeMin)
                var delayTimeMin = readBuffer.ReadUshort("", 16);

                // Simple Field (buildingMode)
                var buildingMode = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_StatusLightingActuator ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (validactualvalue)
                var validactualvalue = readBuffer.ReadBit("");

                // Simple Field (locked)
                var locked = readBuffer.ReadBit("");

                // Simple Field (forced)
                var forced = readBuffer.ReadBit("");

                // Simple Field (nightmodeactive)
                var nightmodeactive = readBuffer.ReadBit("");

                // Simple Field (staircaselightingFunction)
                var staircaselightingFunction = readBuffer.ReadBit("");

                // Simple Field (dimming)
                var dimming = readBuffer.ReadBit("");

                // Simple Field (localoverride)
                var localoverride = readBuffer.ReadBit("");

                // Simple Field (failure)
                var failure = readBuffer.ReadBit("");

                // Simple Field (actualvalue)
                var actualvalue = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Version ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (magicNumber)
                var magicNumber = readBuffer.ReadByte("", 5);

                // Simple Field (versionNumber)
                var versionNumber = readBuffer.ReadByte("", 5);

                // Simple Field (revisionNumber)
                var revisionNumber = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_AlarmInfo ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (logNumber)
                var logNumber = readBuffer.ReadByte("", 8);

                // Simple Field (alarmPriority)
                var alarmPriority = readBuffer.ReadByte("", 8);

                // Simple Field (applicationArea)
                var applicationArea = readBuffer.ReadByte("", 8);

                // Simple Field (errorClass)
                var errorClass = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (errorcodeSup)
                var errorcodeSup = readBuffer.ReadBit("");

                // Simple Field (alarmtextSup)
                var alarmtextSup = readBuffer.ReadBit("");

                // Simple Field (timestampSup)
                var timestampSup = readBuffer.ReadBit("");

                // Simple Field (ackSup)
                var ackSup = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (locked)
                var locked = readBuffer.ReadBit("");

                // Simple Field (alarmunack)
                var alarmunack = readBuffer.ReadBit("");

                // Simple Field (inalarm)
                var inalarm = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetF16_3 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (tempsetpcomf)
                var tempsetpcomf = readBuffer.ReadFloat("", 16);

                // Simple Field (tempsetpstdby)
                var tempsetpstdby = readBuffer.ReadFloat("", 16);

                // Simple Field (tempsetpeco)
                var tempsetpeco = readBuffer.ReadFloat("", 16);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (tempsetpshiftcomf)
                var tempsetpshiftcomf = readBuffer.ReadFloat("", 16);

                // Simple Field (tempsetpshiftstdby)
                var tempsetpshiftstdby = readBuffer.ReadFloat("", 16);

                // Simple Field (tempsetpshifteco)
                var tempsetpshifteco = readBuffer.ReadFloat("", 16);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Scaling_Speed ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (timePeriod)
                var timePeriod = readBuffer.ReadUshort("", 16);

                // Simple Field (percent)
                var percent = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Scaling_Step_Time ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (timePeriod)
                var timePeriod = readBuffer.ReadUshort("", 16);

                // Simple Field (percent)
                var percent = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_MeteringValue ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (countval)
                var countval = readBuffer.ReadInt("", 32);

                // Simple Field (valinffield)
                var valinffield = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (alarmunack)
                var alarmunack = readBuffer.ReadBit("");

                // Simple Field (inalarm)
                var inalarm = readBuffer.ReadBit("");

                // Simple Field (overridden)
                var overridden = readBuffer.ReadBit("");

                // Simple Field (fault)
                var fault = readBuffer.ReadBit("");

                // Simple Field (outofservice)
                var outofservice = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_MBus_Address ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (manufactid)
                var manufactid = readBuffer.ReadUshort("", 16);

                // Simple Field (identnumber)
                var identnumber = readBuffer.ReadUint("", 32);

                // Simple Field (version)
                var version = readBuffer.ReadByte("", 8);

                // Simple Field (medium)
                var medium = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Colour_RGB ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (r)
                var r = readBuffer.ReadByte("", 8);

                // Simple Field (g)
                var g = readBuffer.ReadByte("", 8);

                // Simple Field (b)
                var b = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII ) { // STRING

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (value)
                var value = readBuffer.ReadString("", 16, System.Text.Encoding.GetEncoding("ASCII"));

                return new PlcSTRING(value);
            } if( datapointType == KnxDatapointType.DPT_Tariff_ActiveEnergy ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (activeelectricalenergy)
                var activeelectricalenergy = readBuffer.ReadInt("", 32);

                // Simple Field (tariff)
                var tariff = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (electricalengergyvalidity)
                var electricalengergyvalidity = readBuffer.ReadBit("");

                // Simple Field (tariffvalidity)
                var tariffvalidity = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Prioritised_Mode_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (deactivationOfPriority)
                var deactivationOfPriority = readBuffer.ReadBit("");

                // Simple Field (priorityLevel)
                var priorityLevel = readBuffer.ReadByte("", 3);

                // Simple Field (modeLevel)
                var modeLevel = readBuffer.ReadByte("", 4);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (convertorError)
                var convertorError = readBuffer.ReadBit("");

                // Simple Field (ballastFailure)
                var ballastFailure = readBuffer.ReadBit("");

                // Simple Field (lampFailure)
                var lampFailure = readBuffer.ReadBit("");

                // Simple Field (readOrResponse)
                var readOrResponse = readBuffer.ReadBit("");

                // Simple Field (addressIndicator)
                var addressIndicator = readBuffer.ReadBit("");

                // Simple Field (daliDeviceAddressOrDaliGroupAddress)
                var daliDeviceAddressOrDaliGroupAddress = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_DALI_Diagnostics ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (ballastFailure)
                var ballastFailure = readBuffer.ReadBit("");

                // Simple Field (lampFailure)
                var lampFailure = readBuffer.ReadBit("");

                // Simple Field (deviceAddress)
                var deviceAddress = readBuffer.ReadByte("", 6);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_CombinedPosition ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (heightPosition)
                var heightPosition = readBuffer.ReadByte("", 8);

                // Simple Field (slatsPosition)
                var slatsPosition = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (validitySlatsPosition)
                var validitySlatsPosition = readBuffer.ReadBit("");

                // Simple Field (validityHeightPosition)
                var validityHeightPosition = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_StatusSAB ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (heightPosition)
                var heightPosition = readBuffer.ReadByte("", 8);

                // Simple Field (slatsPosition)
                var slatsPosition = readBuffer.ReadByte("", 8);

                // Simple Field (upperEndPosReached)
                var upperEndPosReached = readBuffer.ReadBit("");

                // Simple Field (lowerEndPosReached)
                var lowerEndPosReached = readBuffer.ReadBit("");

                // Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
                var lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent = readBuffer.ReadBit("");

                // Simple Field (targetPosDrive)
                var targetPosDrive = readBuffer.ReadBit("");

                // Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
                var restrictionOfTargetHeightPosPosCanNotBeReached = readBuffer.ReadBit("");

                // Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
                var restrictionOfSlatsHeightPosPosCanNotBeReached = readBuffer.ReadBit("");

                // Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
                var atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm = readBuffer.ReadBit("");

                // Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
                var upDownPositionIsForcedByMoveupdownforcedInput = readBuffer.ReadBit("");

                // Simple Field (movementIsLockedEGByDevicelockedInput)
                var movementIsLockedEGByDevicelockedInput = readBuffer.ReadBit("");

                // Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
                var actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface = readBuffer.ReadBit("");

                // Simple Field (generalFailureOfTheActuatorOrTheDrive)
                var generalFailureOfTheActuatorOrTheDrive = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 3);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (validityHeightPos)
                var validityHeightPos = readBuffer.ReadBit("");

                // Simple Field (validitySlatsPos)
                var validitySlatsPos = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Colour_xyY ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (xAxis)
                var xAxis = readBuffer.ReadUshort("", 16);

                // Simple Field (yAxis)
                var yAxis = readBuffer.ReadUshort("", 16);

                // Simple Field (brightness)
                var brightness = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (validityXy)
                var validityXy = readBuffer.ReadBit("");

                // Simple Field (validityBrightness)
                var validityBrightness = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Converter_Status ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
                var converterModeAccordingToTheDaliConverterStateMachine = readBuffer.ReadByte("", 4);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (hardwiredSwitchIsActive)
                var hardwiredSwitchIsActive = readBuffer.ReadBit("");

                // Simple Field (hardwiredInhibitIsActive)
                var hardwiredInhibitIsActive = readBuffer.ReadBit("");

                // Simple Field (functionTestPending)
                var functionTestPending = readBuffer.ReadByte("", 2);

                // Simple Field (durationTestPending)
                var durationTestPending = readBuffer.ReadByte("", 2);

                // Simple Field (partialDurationTestPending)
                var partialDurationTestPending = readBuffer.ReadByte("", 2);

                // Simple Field (converterFailure)
                var converterFailure = readBuffer.ReadByte("", 2);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Converter_Test_Result ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (ltrf)
                var ltrf = readBuffer.ReadByte("", 4);

                // Simple Field (ltrd)
                var ltrd = readBuffer.ReadByte("", 4);

                // Simple Field (ltrp)
                var ltrp = readBuffer.ReadByte("", 4);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (sf)
                var sf = readBuffer.ReadByte("", 2);

                // Simple Field (sd)
                var sd = readBuffer.ReadByte("", 2);

                // Simple Field (sp)
                var sp = readBuffer.ReadByte("", 2);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 2);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (ldtr)
                var ldtr = readBuffer.ReadUshort("", 16);

                // Simple Field (lpdtr)
                var lpdtr = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Battery_Info ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (batteryFailure)
                var batteryFailure = readBuffer.ReadBit("");

                // Simple Field (batteryDurationFailure)
                var batteryDurationFailure = readBuffer.ReadBit("");

                // Simple Field (batteryFullyCharged)
                var batteryFullyCharged = readBuffer.ReadBit("");

                // Simple Field (batteryChargeLevel)
                var batteryChargeLevel = readBuffer.ReadByte("", 8);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (ms)
                var ms = readBuffer.ReadUshort("", 16);

                // Simple Field (temperatureK)
                var temperatureK = readBuffer.ReadUshort("", 16);

                // Simple Field (percent)
                var percent = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 5);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (validityOfTheTimePeriod)
                var validityOfTheTimePeriod = readBuffer.ReadBit("");

                // Simple Field (validityOfTheAbsoluteColourTemperature)
                var validityOfTheAbsoluteColourTemperature = readBuffer.ReadBit("");

                // Simple Field (validityOfTheAbsoluteBrightness)
                var validityOfTheAbsoluteBrightness = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Brightness_Colour_Temperature_Control ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cct)
                var cct = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourTemperature)
                var stepCodeColourTemperature = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cb)
                var cb = readBuffer.ReadBit("");

                // Simple Field (stepCodeBrightness)
                var stepCodeBrightness = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 6);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cctAndStepCodeColourValidity)
                var cctAndStepCodeColourValidity = readBuffer.ReadBit("");

                // Simple Field (cbAndStepCodeBrightnessValidity)
                var cbAndStepCodeBrightnessValidity = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Colour_RGBW ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (colourLevelRed)
                var colourLevelRed = readBuffer.ReadByte("", 8);

                // Simple Field (colourLevelGreen)
                var colourLevelGreen = readBuffer.ReadByte("", 8);

                // Simple Field (colourLevelBlue)
                var colourLevelBlue = readBuffer.ReadByte("", 8);

                // Simple Field (colourLevelWhite)
                var colourLevelWhite = readBuffer.ReadByte("", 8);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (mr)
                var mr = readBuffer.ReadBit("");

                // Simple Field (mg)
                var mg = readBuffer.ReadBit("");

                // Simple Field (mb)
                var mb = readBuffer.ReadBit("");

                // Simple Field (mw)
                var mw = readBuffer.ReadBit("");

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Relative_Control_RGBW ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (maskcw)
                var maskcw = readBuffer.ReadBit("");

                // Simple Field (maskcb)
                var maskcb = readBuffer.ReadBit("");

                // Simple Field (maskcg)
                var maskcg = readBuffer.ReadBit("");

                // Simple Field (maskcr)
                var maskcr = readBuffer.ReadBit("");

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cw)
                var cw = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourWhite)
                var stepCodeColourWhite = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cb)
                var cb = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourBlue)
                var stepCodeColourBlue = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cg)
                var cg = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourGreen)
                var stepCodeColourGreen = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cr)
                var cr = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourRed)
                var stepCodeColourRed = readBuffer.ReadByte("", 3);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_Relative_Control_RGB ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cb)
                var cb = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourBlue)
                var stepCodeColourBlue = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cg)
                var cg = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourGreen)
                var stepCodeColourGreen = readBuffer.ReadByte("", 3);

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 4);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (cr)
                var cr = readBuffer.ReadBit("");

                // Simple Field (stepCodeColourRed)
                var stepCodeColourRed = readBuffer.ReadByte("", 3);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_GeographicalLocation ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (longitude)
                var longitude = readBuffer.ReadFloat("", 32);

                // Simple Field (latitude)
                var latitude = readBuffer.ReadFloat("", 32);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetF16_4 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (roomTemperatureSetpointComfort)
                var roomTemperatureSetpointComfort = readBuffer.ReadFloat("", 16);

                // Simple Field (roomTemperatureSetpointStandby)
                var roomTemperatureSetpointStandby = readBuffer.ReadFloat("", 16);

                // Simple Field (roomTemperatureSetpointEconomy)
                var roomTemperatureSetpointEconomy = readBuffer.ReadFloat("", 16);

                // Simple Field (roomTemperatureSetpointBuildingProtection)
                var roomTemperatureSetpointBuildingProtection = readBuffer.ReadFloat("", 16);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4 ) { // Struct

                // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
                {
                    var reserved = readBuffer.ReadByte("", 8);
                    if(reserved != 0x00) {
                        Logger.Info("Expected constant value {expected} but got {got} for reserved field.", 0x00, reserved);
                    }
                }

                // Simple Field (roomTemperatureSetpointShiftComfort)
                var roomTemperatureSetpointShiftComfort = readBuffer.ReadFloat("", 16);

                // Simple Field (roomTemperatureSetpointShiftStandby)
                var roomTemperatureSetpointShiftStandby = readBuffer.ReadFloat("", 16);

                // Simple Field (roomTemperatureSetpointShiftEconomy)
                var roomTemperatureSetpointShiftEconomy = readBuffer.ReadFloat("", 16);

                // Simple Field (roomTemperatureSetpointShiftBuildingProtection)
                var roomTemperatureSetpointShiftBuildingProtection = readBuffer.ReadFloat("", 16);

                var _map = new Dictionary<string, IPlcValue>();

                return new PlcStruct(_map);
            } 
            return null;
        }

            public static WriteBuffer StaticSerialize(IPlcValue _value, KnxDatapointType datapointType)
            {
                return StaticSerialize(_value, datapointType, ByteOrder.BIG_ENDIAN);
            }

            public static WriteBuffer StaticSerialize(IPlcValue _value, KnxDatapointType datapointType, ByteOrder byteOrder)
            {
if( datapointType == KnxDatapointType.BOOL ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.BYTE ) { // BYTE
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.WORD ) { // WORD
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DWORD ) { // DWORD
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.LWORD ) { // LWORD
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ulong) _value.GetUlong();
                writeBuffer.WriteUlong("", 64, (ulong) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.USINT ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.SINT ) { // SINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (sbyte) _value.GetSbyte();
                writeBuffer.WriteSbyte("", 8, (sbyte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.UINT ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.INT ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.UDINT ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DINT ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.ULINT ) { // ULINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ulong) _value.GetUlong();
                writeBuffer.WriteUlong("", 64, (ulong) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.LINT ) { // LINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (long) _value.GetLong();
                writeBuffer.WriteLong("", 64, (long) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.REAL ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.LREAL ) { // LREAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (double) _value.GetDouble();
                writeBuffer.WriteDouble("", 64,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.CHAR ) { // CHAR
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 8, "UTF-8", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.WCHAR ) { // WCHAR
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 16, "UTF-16", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.TIME ) { // TIME
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (milliseconds)
                var milliseconds = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (milliseconds));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.LTIME ) { // LTIME
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (nanoseconds)
                var nanoseconds = (ulong) _value.GetUlong();
                writeBuffer.WriteUlong("", 64, (ulong) (nanoseconds));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DATE ) { // DATE
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (secondsSinceEpoch)
                var secondsSinceEpoch = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (secondsSinceEpoch));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.TIME_OF_DAY ) { // TIME_OF_DAY
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (millisecondsSinceMidnight)
                var millisecondsSinceMidnight = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (millisecondsSinceMidnight));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.TOD ) { // TIME_OF_DAY
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (millisecondsSinceMidnight)
                var millisecondsSinceMidnight = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (millisecondsSinceMidnight));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DATE_AND_TIME ) { // DATE_AND_TIME
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (year)
                var year = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (year));
                // Simple Field (month)
                var month = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (month));
                // Simple Field (day)
                var day = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (day));
                // Simple Field (dayOfWeek)
                var dayOfWeek = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (dayOfWeek));
                // Simple Field (hour)
                var hour = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (hour));
                // Simple Field (minutes)
                var minutes = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (minutes));
                // Simple Field (seconds)
                var seconds = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (seconds));
                // Simple Field (nanoseconds)
                var nanoseconds = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (nanoseconds));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DT ) { // DATE_AND_TIME
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (year)
                var year = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (year));
                // Simple Field (month)
                var month = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (month));
                // Simple Field (day)
                var day = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (day));
                // Simple Field (dayOfWeek)
                var dayOfWeek = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (dayOfWeek));
                // Simple Field (hour)
                var hour = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (hour));
                // Simple Field (minutes)
                var minutes = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (minutes));
                // Simple Field (seconds)
                var seconds = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (seconds));
                // Simple Field (nanoseconds)
                var nanoseconds = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (nanoseconds));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Switch ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Bool ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Enable ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Ramp ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Alarm ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BinaryValue ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Step ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_UpDown ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_OpenClose ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Start ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_State ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Invert ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DimSendStyle ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_InputSource ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Reset ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Ack ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Trigger ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Occupancy ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Window_Door ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LogicalFunction ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Scene_AB ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ShutterBlinds_Mode ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DayNight ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Heat_Cool ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Switch_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (on)
                var on = (bool) _value.GetStruct()["on"].GetBool();
                writeBuffer.WriteBit("", (on));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Bool_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (valueTrue)
                var valueTrue = (bool) _value.GetStruct()["valueTrue"].GetBool();
                writeBuffer.WriteBit("", (valueTrue));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Enable_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (enable)
                var enable = (bool) _value.GetStruct()["enable"].GetBool();
                writeBuffer.WriteBit("", (enable));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Ramp_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (ramp)
                var ramp = (bool) _value.GetStruct()["ramp"].GetBool();
                writeBuffer.WriteBit("", (ramp));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Alarm_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (alarm)
                var alarm = (bool) _value.GetStruct()["alarm"].GetBool();
                writeBuffer.WriteBit("", (alarm));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BinaryValue_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (high)
                var high = (bool) _value.GetStruct()["high"].GetBool();
                writeBuffer.WriteBit("", (high));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Step_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (increase)
                var increase = (bool) _value.GetStruct()["increase"].GetBool();
                writeBuffer.WriteBit("", (increase));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Direction1_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (down)
                var down = (bool) _value.GetStruct()["down"].GetBool();
                writeBuffer.WriteBit("", (down));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Direction2_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (close)
                var close = (bool) _value.GetStruct()["close"].GetBool();
                writeBuffer.WriteBit("", (close));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Start_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (start)
                var start = (bool) _value.GetStruct()["start"].GetBool();
                writeBuffer.WriteBit("", (start));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_State_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (active)
                var active = (bool) _value.GetStruct()["active"].GetBool();
                writeBuffer.WriteBit("", (active));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Invert_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (control)
                var control = (bool) _value.GetStruct()["control"].GetBool();
                writeBuffer.WriteBit("", (control));
                // Simple Field (inverted)
                var inverted = (bool) _value.GetStruct()["inverted"].GetBool();
                writeBuffer.WriteBit("", (inverted));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Control_Dimming ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (increase)
                var increase = (bool) _value.GetStruct()["increase"].GetBool();
                writeBuffer.WriteBit("", (increase));
                // Simple Field (stepcode)
                var stepcode = (byte) _value.GetStruct()["stepcode"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepcode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Control_Blinds ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (down)
                var down = (bool) _value.GetStruct()["down"].GetBool();
                writeBuffer.WriteBit("", (down));
                // Simple Field (stepcode)
                var stepcode = (byte) _value.GetStruct()["stepcode"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepcode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Char_ASCII ) { // STRING
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 8, "ASCII", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Char_8859_1 ) { // STRING
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 8, "ISO-8859-1", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Scaling ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Angle ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Percent_U8 ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DecimalFactor ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Tariff ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_1_Ucount ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_FanStage ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Percent_V8 ) { // SINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (sbyte) _value.GetSbyte();
                writeBuffer.WriteSbyte("", 8, (sbyte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_1_Count ) { // SINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (sbyte) _value.GetSbyte();
                writeBuffer.WriteSbyte("", 8, (sbyte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Status_Mode3 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (statusA)
                var statusA = (bool) _value.GetStruct()["statusA"].GetBool();
                writeBuffer.WriteBit("", (statusA));
                // Simple Field (statusB)
                var statusB = (bool) _value.GetStruct()["statusB"].GetBool();
                writeBuffer.WriteBit("", (statusB));
                // Simple Field (statusC)
                var statusC = (bool) _value.GetStruct()["statusC"].GetBool();
                writeBuffer.WriteBit("", (statusC));
                // Simple Field (statusD)
                var statusD = (bool) _value.GetStruct()["statusD"].GetBool();
                writeBuffer.WriteBit("", (statusD));
                // Simple Field (statusE)
                var statusE = (bool) _value.GetStruct()["statusE"].GetBool();
                writeBuffer.WriteBit("", (statusE));
                // Simple Field (mode)
                var mode = (byte) _value.GetStruct()["mode"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (mode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_2_Ucount ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimePeriodMsec ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimePeriod10Msec ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimePeriod100Msec ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimePeriodSec ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimePeriodMin ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimePeriodHrs ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_PropDataType ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Length_mm ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_UElCurrentmA ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Brightness ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Absolute_Colour_Temperature ) { // UINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (ushort) _value.GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_2_Count ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaTimeMsec ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaTime10Msec ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaTime100Msec ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaTimeSec ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaTimeMin ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaTimeHrs ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Percent_V16 ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Rotation_Angle ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Length_m ) { // INT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (short) _value.GetShort();
                writeBuffer.WriteShort("", 16, (short) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Temp ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Tempd ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Tempa ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Lux ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Wsp ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Pres ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Humidity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_AirQuality ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_AirFlow ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Time1 ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Time2 ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Volt ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Curr ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_PowerDensity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_KelvinPerPercent ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Power ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Volume_Flow ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Rain_Amount ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Temp_F ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Wsp_kmh ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Absolute_Humidity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Concentration_ygm3 ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Coefficient ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TimeOfDay ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (day)
                var day = (byte) _value.GetStruct()["day"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (day));
                // Simple Field (hour)
                var hour = (byte) _value.GetStruct()["hour"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (hour));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (minutes)
                var minutes = (byte) _value.GetStruct()["minutes"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (minutes));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (seconds)
                var seconds = (byte) _value.GetStruct()["seconds"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (seconds));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Date ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (dayOfMonth)
                var dayOfMonth = (byte) _value.GetStruct()["dayOfMonth"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (dayOfMonth));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (month)
                var month = (byte) _value.GetStruct()["month"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (month));
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (year)
                var year = (byte) _value.GetStruct()["year"].GetByte();
                writeBuffer.WriteByte("", 7, (byte) (year));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_4_Ucount ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LongTimePeriod_Sec ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LongTimePeriod_Min ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LongTimePeriod_Hrs ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_VolumeLiquid_Litre ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Volume_m_3 ) { // UDINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (uint) _value.GetUint();
                writeBuffer.WriteUint("", 32, (uint) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_4_Count ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_FlowRate_m3h ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ActiveEnergy ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ApparentEnergy ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ReactiveEnergy ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ActiveEnergy_kWh ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ApparentEnergy_kVAh ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ReactiveEnergy_kVARh ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ActiveEnergy_MWh ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LongDeltaTimeSec ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaVolumeLiquid_Litre ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DeltaVolume_m_3 ) { // DINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (int) _value.GetInt();
                writeBuffer.WriteInt("", 32, (int) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Acceleration ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Acceleration_Angular ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Activation_Energy ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Activity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Mol ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Amplitude ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_AngleRad ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_AngleDeg ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Angular_Momentum ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Angular_Velocity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Area ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Capacitance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Charge_DensitySurface ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Charge_DensityVolume ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Compressibility ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Conductance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electrical_Conductivity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Density ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_Charge ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_Current ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_CurrentDensity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_DipoleMoment ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_Displacement ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_FieldStrength ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_Flux ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_FluxDensity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_Polarization ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_Potential ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electric_PotentialDifference ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_ElectromagneticMoment ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Electromotive_Force ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Energy ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Force ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Frequency ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Angular_Frequency ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Heat_Capacity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Heat_FlowRate ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Heat_Quantity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Impedance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Length ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Light_Quantity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Luminance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Luminous_Flux ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Luminous_Intensity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_FieldStrength ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_Flux ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_FluxDensity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_Moment ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Magnetic_Polarization ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Magnetization ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_MagnetomotiveForce ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Mass ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_MassFlux ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Momentum ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Phase_AngleRad ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Phase_AngleDeg ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Power ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Power_Factor ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Pressure ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Reactance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Resistance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Resistivity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_SelfInductance ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_SolidAngle ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Sound_Intensity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Speed ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Stress ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Surface_Tension ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Common_Temperature ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Absolute_Temperature ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_TemperatureDifference ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Thermal_Capacity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Thermal_Conductivity ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_ThermoelectricPower ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Time ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Torque ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Volume ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Volume_Flux ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Weight ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_Work ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Value_ApparentPower ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 32,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Volume_Flux_Meter ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Volume_Flux_ls ) { // REAL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (float) _value.GetFloat();
                writeBuffer.WriteFloat("", 16,(value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Access_Data ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (hurz)
                var hurz = (byte) _value.GetStruct()["hurz"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (hurz));
                // Simple Field (value1)
                var value1 = (byte) _value.GetStruct()["value1"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (value1));
                // Simple Field (value2)
                var value2 = (byte) _value.GetStruct()["value2"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (value2));
                // Simple Field (value3)
                var value3 = (byte) _value.GetStruct()["value3"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (value3));
                // Simple Field (value4)
                var value4 = (byte) _value.GetStruct()["value4"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (value4));
                // Simple Field (value5)
                var value5 = (byte) _value.GetStruct()["value5"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (value5));
                // Simple Field (detectionError)
                var detectionError = (bool) _value.GetStruct()["detectionError"].GetBool();
                writeBuffer.WriteBit("", (detectionError));
                // Simple Field (permission)
                var permission = (bool) _value.GetStruct()["permission"].GetBool();
                writeBuffer.WriteBit("", (permission));
                // Simple Field (readDirection)
                var readDirection = (bool) _value.GetStruct()["readDirection"].GetBool();
                writeBuffer.WriteBit("", (readDirection));
                // Simple Field (encryptionOfAccessInformation)
                var encryptionOfAccessInformation = (bool) _value.GetStruct()["encryptionOfAccessInformation"].GetBool();
                writeBuffer.WriteBit("", (encryptionOfAccessInformation));
                // Simple Field (indexOfAccessIdentificationCode)
                var indexOfAccessIdentificationCode = (byte) _value.GetStruct()["indexOfAccessIdentificationCode"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (indexOfAccessIdentificationCode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_String_ASCII ) { // STRING
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 112, "ASCII", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_String_8859_1 ) { // STRING
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 112, "ISO-8859-1", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SceneNumber ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 6, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SceneControl ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
                var learnTheSceneCorrespondingToTheFieldSceneNumber = (bool) _value.GetStruct()["learnTheSceneCorrespondingToTheFieldSceneNumber"].GetBool();
                writeBuffer.WriteBit("", (learnTheSceneCorrespondingToTheFieldSceneNumber));
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (sceneNumber)
                var sceneNumber = (byte) _value.GetStruct()["sceneNumber"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (sceneNumber));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DateTime ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (year)
                var year = (byte) _value.GetStruct()["year"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (year));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (month)
                var month = (byte) _value.GetStruct()["month"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (month));
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (dayofmonth)
                var dayofmonth = (byte) _value.GetStruct()["dayofmonth"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (dayofmonth));
                // Simple Field (dayofweek)
                var dayofweek = (byte) _value.GetStruct()["dayofweek"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (dayofweek));
                // Simple Field (hourofday)
                var hourofday = (byte) _value.GetStruct()["hourofday"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (hourofday));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (minutes)
                var minutes = (byte) _value.GetStruct()["minutes"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (minutes));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (seconds)
                var seconds = (byte) _value.GetStruct()["seconds"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (seconds));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
                // Simple Field (workingDay)
                var workingDay = (bool) _value.GetStruct()["workingDay"].GetBool();
                writeBuffer.WriteBit("", (workingDay));
                // Simple Field (noWd)
                var noWd = (bool) _value.GetStruct()["noWd"].GetBool();
                writeBuffer.WriteBit("", (noWd));
                // Simple Field (noYear)
                var noYear = (bool) _value.GetStruct()["noYear"].GetBool();
                writeBuffer.WriteBit("", (noYear));
                // Simple Field (noDate)
                var noDate = (bool) _value.GetStruct()["noDate"].GetBool();
                writeBuffer.WriteBit("", (noDate));
                // Simple Field (noDayOfWeek)
                var noDayOfWeek = (bool) _value.GetStruct()["noDayOfWeek"].GetBool();
                writeBuffer.WriteBit("", (noDayOfWeek));
                // Simple Field (noTime)
                var noTime = (bool) _value.GetStruct()["noTime"].GetBool();
                writeBuffer.WriteBit("", (noTime));
                // Simple Field (standardSummerTime)
                var standardSummerTime = (bool) _value.GetStruct()["standardSummerTime"].GetBool();
                writeBuffer.WriteBit("", (standardSummerTime));
                // Simple Field (qualityOfClock)
                var qualityOfClock = (bool) _value.GetStruct()["qualityOfClock"].GetBool();
                writeBuffer.WriteBit("", (qualityOfClock));
                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SCLOMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BuildingMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_OccMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Priority ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LightApplicationMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ApplicationArea ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_AlarmClassType ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_PSUMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ErrorClass_System ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ErrorClass_HVAC ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Time_Delay ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Beaufort_Wind_Force_Scale ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SensorSelect ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ActuatorConnectType ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Cloud_Cover ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_PowerReturnMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_FuelType ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BurnerType ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HVACMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DHWMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LoadPriority ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HVACContrMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HVACEmergMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ChangeoverMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ValveMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DamperMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HeaterMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_FanMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_MasterSlaveMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusRoomSetp ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Metering_DeviceType ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HumDehumMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_EnableHCStage ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ADAType ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BackupMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StartSynchronization ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Behaviour_Lock_Unlock ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DALI_Fade_Time ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BlinkingMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LightControlMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SwitchPBModel ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_PBAction ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DimmPBModel ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SwitchOnMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LoadTypeSet ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LoadTypeDetected ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Converter_Test_Control ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Converter_Control ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SABExcept_Behaviour ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SABBehaviour_Lock_Unlock ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SSSBMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BlindsControlMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_CommMode ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_AddInfoTypes ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_RF_ModeSelect ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_RF_FilterSelect ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 8, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusGen ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
                var alarmStatusOfCorrespondingDatapointIsNotAcknowledged = (bool) _value.GetStruct()["alarmStatusOfCorrespondingDatapointIsNotAcknowledged"].GetBool();
                writeBuffer.WriteBit("", (alarmStatusOfCorrespondingDatapointIsNotAcknowledged));
                // Simple Field (correspondingDatapointIsInAlarm)
                var correspondingDatapointIsInAlarm = (bool) _value.GetStruct()["correspondingDatapointIsInAlarm"].GetBool();
                writeBuffer.WriteBit("", (correspondingDatapointIsInAlarm));
                // Simple Field (correspondingDatapointMainValueIsOverridden)
                var correspondingDatapointMainValueIsOverridden = (bool) _value.GetStruct()["correspondingDatapointMainValueIsOverridden"].GetBool();
                writeBuffer.WriteBit("", (correspondingDatapointMainValueIsOverridden));
                // Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
                var correspondingDatapointMainValueIsCorruptedDueToFailure = (bool) _value.GetStruct()["correspondingDatapointMainValueIsCorruptedDueToFailure"].GetBool();
                writeBuffer.WriteBit("", (correspondingDatapointMainValueIsCorruptedDueToFailure));
                // Simple Field (correspondingDatapointValueIsOutOfService)
                var correspondingDatapointValueIsOutOfService = (bool) _value.GetStruct()["correspondingDatapointValueIsOutOfService"].GetBool();
                writeBuffer.WriteBit("", (correspondingDatapointValueIsOutOfService));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Device_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (verifyModeIsOn)
                var verifyModeIsOn = (bool) _value.GetStruct()["verifyModeIsOn"].GetBool();
                writeBuffer.WriteBit("", (verifyModeIsOn));
                // Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
                var aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived = (bool) _value.GetStruct()["aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived"].GetBool();
                writeBuffer.WriteBit("", (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived));
                // Simple Field (theUserApplicationIsStopped)
                var theUserApplicationIsStopped = (bool) _value.GetStruct()["theUserApplicationIsStopped"].GetBool();
                writeBuffer.WriteBit("", (theUserApplicationIsStopped));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ForceSign ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (roomhmax)
                var roomhmax = (bool) _value.GetStruct()["roomhmax"].GetBool();
                writeBuffer.WriteBit("", (roomhmax));
                // Simple Field (roomhconf)
                var roomhconf = (bool) _value.GetStruct()["roomhconf"].GetBool();
                writeBuffer.WriteBit("", (roomhconf));
                // Simple Field (dhwlegio)
                var dhwlegio = (bool) _value.GetStruct()["dhwlegio"].GetBool();
                writeBuffer.WriteBit("", (dhwlegio));
                // Simple Field (dhwnorm)
                var dhwnorm = (bool) _value.GetStruct()["dhwnorm"].GetBool();
                writeBuffer.WriteBit("", (dhwnorm));
                // Simple Field (overrun)
                var overrun = (bool) _value.GetStruct()["overrun"].GetBool();
                writeBuffer.WriteBit("", (overrun));
                // Simple Field (oversupply)
                var oversupply = (bool) _value.GetStruct()["oversupply"].GetBool();
                writeBuffer.WriteBit("", (oversupply));
                // Simple Field (protection)
                var protection = (bool) _value.GetStruct()["protection"].GetBool();
                writeBuffer.WriteBit("", (protection));
                // Simple Field (forcerequest)
                var forcerequest = (bool) _value.GetStruct()["forcerequest"].GetBool();
                writeBuffer.WriteBit("", (forcerequest));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ForceSignCool ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusRHC ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (summermode)
                var summermode = (bool) _value.GetStruct()["summermode"].GetBool();
                writeBuffer.WriteBit("", (summermode));
                // Simple Field (statusstopoptim)
                var statusstopoptim = (bool) _value.GetStruct()["statusstopoptim"].GetBool();
                writeBuffer.WriteBit("", (statusstopoptim));
                // Simple Field (statusstartoptim)
                var statusstartoptim = (bool) _value.GetStruct()["statusstartoptim"].GetBool();
                writeBuffer.WriteBit("", (statusstartoptim));
                // Simple Field (statusmorningboost)
                var statusmorningboost = (bool) _value.GetStruct()["statusmorningboost"].GetBool();
                writeBuffer.WriteBit("", (statusmorningboost));
                // Simple Field (tempreturnlimit)
                var tempreturnlimit = (bool) _value.GetStruct()["tempreturnlimit"].GetBool();
                writeBuffer.WriteBit("", (tempreturnlimit));
                // Simple Field (tempflowlimit)
                var tempflowlimit = (bool) _value.GetStruct()["tempflowlimit"].GetBool();
                writeBuffer.WriteBit("", (tempflowlimit));
                // Simple Field (satuseco)
                var satuseco = (bool) _value.GetStruct()["satuseco"].GetBool();
                writeBuffer.WriteBit("", (satuseco));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusSDHWC ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (solarloadsufficient)
                var solarloadsufficient = (bool) _value.GetStruct()["solarloadsufficient"].GetBool();
                writeBuffer.WriteBit("", (solarloadsufficient));
                // Simple Field (sdhwloadactive)
                var sdhwloadactive = (bool) _value.GetStruct()["sdhwloadactive"].GetBool();
                writeBuffer.WriteBit("", (sdhwloadactive));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_FuelTypeSet ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (solidstate)
                var solidstate = (bool) _value.GetStruct()["solidstate"].GetBool();
                writeBuffer.WriteBit("", (solidstate));
                // Simple Field (gas)
                var gas = (bool) _value.GetStruct()["gas"].GetBool();
                writeBuffer.WriteBit("", (gas));
                // Simple Field (oil)
                var oil = (bool) _value.GetStruct()["oil"].GetBool();
                writeBuffer.WriteBit("", (oil));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusRCC ) { // BOOL
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (value)
                var value = (bool) _value.GetBool();
                writeBuffer.WriteBit("", (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusAHU ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cool)
                var cool = (bool) _value.GetStruct()["cool"].GetBool();
                writeBuffer.WriteBit("", (cool));
                // Simple Field (heat)
                var heat = (bool) _value.GetStruct()["heat"].GetBool();
                writeBuffer.WriteBit("", (heat));
                // Simple Field (fanactive)
                var fanactive = (bool) _value.GetStruct()["fanactive"].GetBool();
                writeBuffer.WriteBit("", (fanactive));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_CombinedStatus_RTSM ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (statusOfHvacModeUser)
                var statusOfHvacModeUser = (bool) _value.GetStruct()["statusOfHvacModeUser"].GetBool();
                writeBuffer.WriteBit("", (statusOfHvacModeUser));
                // Simple Field (statusOfComfortProlongationUser)
                var statusOfComfortProlongationUser = (bool) _value.GetStruct()["statusOfComfortProlongationUser"].GetBool();
                writeBuffer.WriteBit("", (statusOfComfortProlongationUser));
                // Simple Field (effectiveValueOfTheComfortPushButton)
                var effectiveValueOfTheComfortPushButton = (bool) _value.GetStruct()["effectiveValueOfTheComfortPushButton"].GetBool();
                writeBuffer.WriteBit("", (effectiveValueOfTheComfortPushButton));
                // Simple Field (effectiveValueOfThePresenceStatus)
                var effectiveValueOfThePresenceStatus = (bool) _value.GetStruct()["effectiveValueOfThePresenceStatus"].GetBool();
                writeBuffer.WriteBit("", (effectiveValueOfThePresenceStatus));
                // Simple Field (effectiveValueOfTheWindowStatus)
                var effectiveValueOfTheWindowStatus = (bool) _value.GetStruct()["effectiveValueOfTheWindowStatus"].GetBool();
                writeBuffer.WriteBit("", (effectiveValueOfTheWindowStatus));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LightActuatorErrorInfo ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (overheat)
                var overheat = (bool) _value.GetStruct()["overheat"].GetBool();
                writeBuffer.WriteBit("", (overheat));
                // Simple Field (lampfailure)
                var lampfailure = (bool) _value.GetStruct()["lampfailure"].GetBool();
                writeBuffer.WriteBit("", (lampfailure));
                // Simple Field (defectiveload)
                var defectiveload = (bool) _value.GetStruct()["defectiveload"].GetBool();
                writeBuffer.WriteBit("", (defectiveload));
                // Simple Field (underload)
                var underload = (bool) _value.GetStruct()["underload"].GetBool();
                writeBuffer.WriteBit("", (underload));
                // Simple Field (overcurrent)
                var overcurrent = (bool) _value.GetStruct()["overcurrent"].GetBool();
                writeBuffer.WriteBit("", (overcurrent));
                // Simple Field (undervoltage)
                var undervoltage = (bool) _value.GetStruct()["undervoltage"].GetBool();
                writeBuffer.WriteBit("", (undervoltage));
                // Simple Field (loaddetectionerror)
                var loaddetectionerror = (bool) _value.GetStruct()["loaddetectionerror"].GetBool();
                writeBuffer.WriteBit("", (loaddetectionerror));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_RF_ModeInfo ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (bibatSlave)
                var bibatSlave = (bool) _value.GetStruct()["bibatSlave"].GetBool();
                writeBuffer.WriteBit("", (bibatSlave));
                // Simple Field (bibatMaster)
                var bibatMaster = (bool) _value.GetStruct()["bibatMaster"].GetBool();
                writeBuffer.WriteBit("", (bibatMaster));
                // Simple Field (asynchronous)
                var asynchronous = (bool) _value.GetStruct()["asynchronous"].GetBool();
                writeBuffer.WriteBit("", (asynchronous));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_RF_FilterInfo ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (doa)
                var doa = (bool) _value.GetStruct()["doa"].GetBool();
                writeBuffer.WriteBit("", (doa));
                // Simple Field (knxSn)
                var knxSn = (bool) _value.GetStruct()["knxSn"].GetBool();
                writeBuffer.WriteBit("", (knxSn));
                // Simple Field (doaAndKnxSn)
                var doaAndKnxSn = (bool) _value.GetStruct()["doaAndKnxSn"].GetBool();
                writeBuffer.WriteBit("", (doaAndKnxSn));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Channel_Activation_8 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (activationStateOfChannel1)
                var activationStateOfChannel1 = (bool) _value.GetStruct()["activationStateOfChannel1"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel1));
                // Simple Field (activationStateOfChannel2)
                var activationStateOfChannel2 = (bool) _value.GetStruct()["activationStateOfChannel2"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel2));
                // Simple Field (activationStateOfChannel3)
                var activationStateOfChannel3 = (bool) _value.GetStruct()["activationStateOfChannel3"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel3));
                // Simple Field (activationStateOfChannel4)
                var activationStateOfChannel4 = (bool) _value.GetStruct()["activationStateOfChannel4"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel4));
                // Simple Field (activationStateOfChannel5)
                var activationStateOfChannel5 = (bool) _value.GetStruct()["activationStateOfChannel5"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel5));
                // Simple Field (activationStateOfChannel6)
                var activationStateOfChannel6 = (bool) _value.GetStruct()["activationStateOfChannel6"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel6));
                // Simple Field (activationStateOfChannel7)
                var activationStateOfChannel7 = (bool) _value.GetStruct()["activationStateOfChannel7"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel7));
                // Simple Field (activationStateOfChannel8)
                var activationStateOfChannel8 = (bool) _value.GetStruct()["activationStateOfChannel8"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel8));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusDHWC ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (tempoptimshiftactive)
                var tempoptimshiftactive = (bool) _value.GetStruct()["tempoptimshiftactive"].GetBool();
                writeBuffer.WriteBit("", (tempoptimshiftactive));
                // Simple Field (solarenergysupport)
                var solarenergysupport = (bool) _value.GetStruct()["solarenergysupport"].GetBool();
                writeBuffer.WriteBit("", (solarenergysupport));
                // Simple Field (solarenergyonly)
                var solarenergyonly = (bool) _value.GetStruct()["solarenergyonly"].GetBool();
                writeBuffer.WriteBit("", (solarenergyonly));
                // Simple Field (otherenergysourceactive)
                var otherenergysourceactive = (bool) _value.GetStruct()["otherenergysourceactive"].GetBool();
                writeBuffer.WriteBit("", (otherenergysourceactive));
                // Simple Field (dhwpushactive)
                var dhwpushactive = (bool) _value.GetStruct()["dhwpushactive"].GetBool();
                writeBuffer.WriteBit("", (dhwpushactive));
                // Simple Field (legioprotactive)
                var legioprotactive = (bool) _value.GetStruct()["legioprotactive"].GetBool();
                writeBuffer.WriteBit("", (legioprotactive));
                // Simple Field (dhwloadactive)
                var dhwloadactive = (bool) _value.GetStruct()["dhwloadactive"].GetBool();
                writeBuffer.WriteBit("", (dhwloadactive));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusRHCC ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (overheatalarm)
                var overheatalarm = (bool) _value.GetStruct()["overheatalarm"].GetBool();
                writeBuffer.WriteBit("", (overheatalarm));
                // Simple Field (frostalarm)
                var frostalarm = (bool) _value.GetStruct()["frostalarm"].GetBool();
                writeBuffer.WriteBit("", (frostalarm));
                // Simple Field (dewpointstatus)
                var dewpointstatus = (bool) _value.GetStruct()["dewpointstatus"].GetBool();
                writeBuffer.WriteBit("", (dewpointstatus));
                // Simple Field (coolingdisabled)
                var coolingdisabled = (bool) _value.GetStruct()["coolingdisabled"].GetBool();
                writeBuffer.WriteBit("", (coolingdisabled));
                // Simple Field (statusprecool)
                var statusprecool = (bool) _value.GetStruct()["statusprecool"].GetBool();
                writeBuffer.WriteBit("", (statusprecool));
                // Simple Field (statusecoc)
                var statusecoc = (bool) _value.GetStruct()["statusecoc"].GetBool();
                writeBuffer.WriteBit("", (statusecoc));
                // Simple Field (heatcoolmode)
                var heatcoolmode = (bool) _value.GetStruct()["heatcoolmode"].GetBool();
                writeBuffer.WriteBit("", (heatcoolmode));
                // Simple Field (heatingdiabled)
                var heatingdiabled = (bool) _value.GetStruct()["heatingdiabled"].GetBool();
                writeBuffer.WriteBit("", (heatingdiabled));
                // Simple Field (statusstopoptim)
                var statusstopoptim = (bool) _value.GetStruct()["statusstopoptim"].GetBool();
                writeBuffer.WriteBit("", (statusstopoptim));
                // Simple Field (statusstartoptim)
                var statusstartoptim = (bool) _value.GetStruct()["statusstartoptim"].GetBool();
                writeBuffer.WriteBit("", (statusstartoptim));
                // Simple Field (statusmorningboosth)
                var statusmorningboosth = (bool) _value.GetStruct()["statusmorningboosth"].GetBool();
                writeBuffer.WriteBit("", (statusmorningboosth));
                // Simple Field (tempflowreturnlimit)
                var tempflowreturnlimit = (bool) _value.GetStruct()["tempflowreturnlimit"].GetBool();
                writeBuffer.WriteBit("", (tempflowreturnlimit));
                // Simple Field (tempflowlimit)
                var tempflowlimit = (bool) _value.GetStruct()["tempflowlimit"].GetBool();
                writeBuffer.WriteBit("", (tempflowlimit));
                // Simple Field (statusecoh)
                var statusecoh = (bool) _value.GetStruct()["statusecoh"].GetBool();
                writeBuffer.WriteBit("", (statusecoh));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_CombinedStatus_HVA ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (calibrationMode)
                var calibrationMode = (bool) _value.GetStruct()["calibrationMode"].GetBool();
                writeBuffer.WriteBit("", (calibrationMode));
                // Simple Field (lockedPosition)
                var lockedPosition = (bool) _value.GetStruct()["lockedPosition"].GetBool();
                writeBuffer.WriteBit("", (lockedPosition));
                // Simple Field (forcedPosition)
                var forcedPosition = (bool) _value.GetStruct()["forcedPosition"].GetBool();
                writeBuffer.WriteBit("", (forcedPosition));
                // Simple Field (manuaOperationOverridden)
                var manuaOperationOverridden = (bool) _value.GetStruct()["manuaOperationOverridden"].GetBool();
                writeBuffer.WriteBit("", (manuaOperationOverridden));
                // Simple Field (serviceMode)
                var serviceMode = (bool) _value.GetStruct()["serviceMode"].GetBool();
                writeBuffer.WriteBit("", (serviceMode));
                // Simple Field (valveKick)
                var valveKick = (bool) _value.GetStruct()["valveKick"].GetBool();
                writeBuffer.WriteBit("", (valveKick));
                // Simple Field (overload)
                var overload = (bool) _value.GetStruct()["overload"].GetBool();
                writeBuffer.WriteBit("", (overload));
                // Simple Field (shortCircuit)
                var shortCircuit = (bool) _value.GetStruct()["shortCircuit"].GetBool();
                writeBuffer.WriteBit("", (shortCircuit));
                // Simple Field (currentValvePosition)
                var currentValvePosition = (bool) _value.GetStruct()["currentValvePosition"].GetBool();
                writeBuffer.WriteBit("", (currentValvePosition));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_CombinedStatus_RTC ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 7, (byte) 0x00);
                // Simple Field (coolingModeEnabled)
                var coolingModeEnabled = (bool) _value.GetStruct()["coolingModeEnabled"].GetBool();
                writeBuffer.WriteBit("", (coolingModeEnabled));
                // Simple Field (heatingModeEnabled)
                var heatingModeEnabled = (bool) _value.GetStruct()["heatingModeEnabled"].GetBool();
                writeBuffer.WriteBit("", (heatingModeEnabled));
                // Simple Field (additionalHeatingCoolingStage2Stage)
                var additionalHeatingCoolingStage2Stage = (bool) _value.GetStruct()["additionalHeatingCoolingStage2Stage"].GetBool();
                writeBuffer.WriteBit("", (additionalHeatingCoolingStage2Stage));
                // Simple Field (controllerInactive)
                var controllerInactive = (bool) _value.GetStruct()["controllerInactive"].GetBool();
                writeBuffer.WriteBit("", (controllerInactive));
                // Simple Field (overheatAlarm)
                var overheatAlarm = (bool) _value.GetStruct()["overheatAlarm"].GetBool();
                writeBuffer.WriteBit("", (overheatAlarm));
                // Simple Field (frostAlarm)
                var frostAlarm = (bool) _value.GetStruct()["frostAlarm"].GetBool();
                writeBuffer.WriteBit("", (frostAlarm));
                // Simple Field (dewPointStatus)
                var dewPointStatus = (bool) _value.GetStruct()["dewPointStatus"].GetBool();
                writeBuffer.WriteBit("", (dewPointStatus));
                // Simple Field (activeMode)
                var activeMode = (bool) _value.GetStruct()["activeMode"].GetBool();
                writeBuffer.WriteBit("", (activeMode));
                // Simple Field (generalFailureInformation)
                var generalFailureInformation = (bool) _value.GetStruct()["generalFailureInformation"].GetBool();
                writeBuffer.WriteBit("", (generalFailureInformation));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Media ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteUshort("", 10, (ushort) 0x00);
                // Simple Field (knxIp)
                var knxIp = (bool) _value.GetStruct()["knxIp"].GetBool();
                writeBuffer.WriteBit("", (knxIp));
                // Simple Field (rf)
                var rf = (bool) _value.GetStruct()["rf"].GetBool();
                writeBuffer.WriteBit("", (rf));
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (pl110)
                var pl110 = (bool) _value.GetStruct()["pl110"].GetBool();
                writeBuffer.WriteBit("", (pl110));
                // Simple Field (tp1)
                var tp1 = (bool) _value.GetStruct()["tp1"].GetBool();
                writeBuffer.WriteBit("", (tp1));
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Channel_Activation_16 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (activationStateOfChannel1)
                var activationStateOfChannel1 = (bool) _value.GetStruct()["activationStateOfChannel1"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel1));
                // Simple Field (activationStateOfChannel2)
                var activationStateOfChannel2 = (bool) _value.GetStruct()["activationStateOfChannel2"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel2));
                // Simple Field (activationStateOfChannel3)
                var activationStateOfChannel3 = (bool) _value.GetStruct()["activationStateOfChannel3"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel3));
                // Simple Field (activationStateOfChannel4)
                var activationStateOfChannel4 = (bool) _value.GetStruct()["activationStateOfChannel4"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel4));
                // Simple Field (activationStateOfChannel5)
                var activationStateOfChannel5 = (bool) _value.GetStruct()["activationStateOfChannel5"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel5));
                // Simple Field (activationStateOfChannel6)
                var activationStateOfChannel6 = (bool) _value.GetStruct()["activationStateOfChannel6"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel6));
                // Simple Field (activationStateOfChannel7)
                var activationStateOfChannel7 = (bool) _value.GetStruct()["activationStateOfChannel7"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel7));
                // Simple Field (activationStateOfChannel8)
                var activationStateOfChannel8 = (bool) _value.GetStruct()["activationStateOfChannel8"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel8));
                // Simple Field (activationStateOfChannel9)
                var activationStateOfChannel9 = (bool) _value.GetStruct()["activationStateOfChannel9"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel9));
                // Simple Field (activationStateOfChannel10)
                var activationStateOfChannel10 = (bool) _value.GetStruct()["activationStateOfChannel10"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel10));
                // Simple Field (activationStateOfChannel11)
                var activationStateOfChannel11 = (bool) _value.GetStruct()["activationStateOfChannel11"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel11));
                // Simple Field (activationStateOfChannel12)
                var activationStateOfChannel12 = (bool) _value.GetStruct()["activationStateOfChannel12"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel12));
                // Simple Field (activationStateOfChannel13)
                var activationStateOfChannel13 = (bool) _value.GetStruct()["activationStateOfChannel13"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel13));
                // Simple Field (activationStateOfChannel14)
                var activationStateOfChannel14 = (bool) _value.GetStruct()["activationStateOfChannel14"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel14));
                // Simple Field (activationStateOfChannel15)
                var activationStateOfChannel15 = (bool) _value.GetStruct()["activationStateOfChannel15"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel15));
                // Simple Field (activationStateOfChannel16)
                var activationStateOfChannel16 = (bool) _value.GetStruct()["activationStateOfChannel16"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel16));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_OnOffAction ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 2, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Alarm_Reaction ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 2, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_UpDown_Action ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 2, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HVAC_PB_Action ) { // USINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (value)
                var value = (byte) _value.GetByte();
                writeBuffer.WriteByte("", 2, (byte) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DoubleNibble ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (busy)
                var busy = (byte) _value.GetStruct()["busy"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (busy));
                // Simple Field (nak)
                var nak = (byte) _value.GetStruct()["nak"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (nak));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_SceneInfo ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 1, (byte) 0x00);
                // Simple Field (sceneIsInactive)
                var sceneIsInactive = (bool) _value.GetStruct()["sceneIsInactive"].GetBool();
                writeBuffer.WriteBit("", (sceneIsInactive));
                // Simple Field (scenenumber)
                var scenenumber = (byte) _value.GetStruct()["scenenumber"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (scenenumber));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_CombinedInfoOnOff ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (maskBitInfoOnOffOutput16)
                var maskBitInfoOnOffOutput16 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput16"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput16));
                // Simple Field (maskBitInfoOnOffOutput15)
                var maskBitInfoOnOffOutput15 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput15"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput15));
                // Simple Field (maskBitInfoOnOffOutput14)
                var maskBitInfoOnOffOutput14 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput14"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput14));
                // Simple Field (maskBitInfoOnOffOutput13)
                var maskBitInfoOnOffOutput13 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput13"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput13));
                // Simple Field (maskBitInfoOnOffOutput12)
                var maskBitInfoOnOffOutput12 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput12"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput12));
                // Simple Field (maskBitInfoOnOffOutput11)
                var maskBitInfoOnOffOutput11 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput11"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput11));
                // Simple Field (maskBitInfoOnOffOutput10)
                var maskBitInfoOnOffOutput10 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput10"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput10));
                // Simple Field (maskBitInfoOnOffOutput9)
                var maskBitInfoOnOffOutput9 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput9"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput9));
                // Simple Field (maskBitInfoOnOffOutput8)
                var maskBitInfoOnOffOutput8 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput8"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput8));
                // Simple Field (maskBitInfoOnOffOutput7)
                var maskBitInfoOnOffOutput7 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput7"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput7));
                // Simple Field (maskBitInfoOnOffOutput6)
                var maskBitInfoOnOffOutput6 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput6"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput6));
                // Simple Field (maskBitInfoOnOffOutput5)
                var maskBitInfoOnOffOutput5 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput5"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput5));
                // Simple Field (maskBitInfoOnOffOutput4)
                var maskBitInfoOnOffOutput4 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput4"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput4));
                // Simple Field (maskBitInfoOnOffOutput3)
                var maskBitInfoOnOffOutput3 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput3"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput3));
                // Simple Field (maskBitInfoOnOffOutput2)
                var maskBitInfoOnOffOutput2 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput2"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput2));
                // Simple Field (maskBitInfoOnOffOutput1)
                var maskBitInfoOnOffOutput1 = (bool) _value.GetStruct()["maskBitInfoOnOffOutput1"].GetBool();
                writeBuffer.WriteBit("", (maskBitInfoOnOffOutput1));
                // Simple Field (infoOnOffOutput16)
                var infoOnOffOutput16 = (bool) _value.GetStruct()["infoOnOffOutput16"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput16));
                // Simple Field (infoOnOffOutput15)
                var infoOnOffOutput15 = (bool) _value.GetStruct()["infoOnOffOutput15"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput15));
                // Simple Field (infoOnOffOutput14)
                var infoOnOffOutput14 = (bool) _value.GetStruct()["infoOnOffOutput14"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput14));
                // Simple Field (infoOnOffOutput13)
                var infoOnOffOutput13 = (bool) _value.GetStruct()["infoOnOffOutput13"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput13));
                // Simple Field (infoOnOffOutput12)
                var infoOnOffOutput12 = (bool) _value.GetStruct()["infoOnOffOutput12"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput12));
                // Simple Field (infoOnOffOutput11)
                var infoOnOffOutput11 = (bool) _value.GetStruct()["infoOnOffOutput11"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput11));
                // Simple Field (infoOnOffOutput10)
                var infoOnOffOutput10 = (bool) _value.GetStruct()["infoOnOffOutput10"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput10));
                // Simple Field (infoOnOffOutput9)
                var infoOnOffOutput9 = (bool) _value.GetStruct()["infoOnOffOutput9"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput9));
                // Simple Field (infoOnOffOutput8)
                var infoOnOffOutput8 = (bool) _value.GetStruct()["infoOnOffOutput8"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput8));
                // Simple Field (infoOnOffOutput7)
                var infoOnOffOutput7 = (bool) _value.GetStruct()["infoOnOffOutput7"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput7));
                // Simple Field (infoOnOffOutput6)
                var infoOnOffOutput6 = (bool) _value.GetStruct()["infoOnOffOutput6"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput6));
                // Simple Field (infoOnOffOutput5)
                var infoOnOffOutput5 = (bool) _value.GetStruct()["infoOnOffOutput5"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput5));
                // Simple Field (infoOnOffOutput4)
                var infoOnOffOutput4 = (bool) _value.GetStruct()["infoOnOffOutput4"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput4));
                // Simple Field (infoOnOffOutput3)
                var infoOnOffOutput3 = (bool) _value.GetStruct()["infoOnOffOutput3"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput3));
                // Simple Field (infoOnOffOutput2)
                var infoOnOffOutput2 = (bool) _value.GetStruct()["infoOnOffOutput2"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput2));
                // Simple Field (infoOnOffOutput1)
                var infoOnOffOutput1 = (bool) _value.GetStruct()["infoOnOffOutput1"].GetBool();
                writeBuffer.WriteBit("", (infoOnOffOutput1));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ActiveEnergy_V64 ) { // LINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (long) _value.GetLong();
                writeBuffer.WriteLong("", 64, (long) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ApparentEnergy_V64 ) { // LINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (long) _value.GetLong();
                writeBuffer.WriteLong("", 64, (long) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_ReactiveEnergy_V64 ) { // LINT
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (long) _value.GetLong();
                writeBuffer.WriteLong("", 64, (long) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Channel_Activation_24 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (activationStateOfChannel1)
                var activationStateOfChannel1 = (bool) _value.GetStruct()["activationStateOfChannel1"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel1));
                // Simple Field (activationStateOfChannel2)
                var activationStateOfChannel2 = (bool) _value.GetStruct()["activationStateOfChannel2"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel2));
                // Simple Field (activationStateOfChannel3)
                var activationStateOfChannel3 = (bool) _value.GetStruct()["activationStateOfChannel3"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel3));
                // Simple Field (activationStateOfChannel4)
                var activationStateOfChannel4 = (bool) _value.GetStruct()["activationStateOfChannel4"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel4));
                // Simple Field (activationStateOfChannel5)
                var activationStateOfChannel5 = (bool) _value.GetStruct()["activationStateOfChannel5"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel5));
                // Simple Field (activationStateOfChannel6)
                var activationStateOfChannel6 = (bool) _value.GetStruct()["activationStateOfChannel6"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel6));
                // Simple Field (activationStateOfChannel7)
                var activationStateOfChannel7 = (bool) _value.GetStruct()["activationStateOfChannel7"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel7));
                // Simple Field (activationStateOfChannel8)
                var activationStateOfChannel8 = (bool) _value.GetStruct()["activationStateOfChannel8"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel8));
                // Simple Field (activationStateOfChannel9)
                var activationStateOfChannel9 = (bool) _value.GetStruct()["activationStateOfChannel9"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel9));
                // Simple Field (activationStateOfChannel10)
                var activationStateOfChannel10 = (bool) _value.GetStruct()["activationStateOfChannel10"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel10));
                // Simple Field (activationStateOfChannel11)
                var activationStateOfChannel11 = (bool) _value.GetStruct()["activationStateOfChannel11"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel11));
                // Simple Field (activationStateOfChannel12)
                var activationStateOfChannel12 = (bool) _value.GetStruct()["activationStateOfChannel12"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel12));
                // Simple Field (activationStateOfChannel13)
                var activationStateOfChannel13 = (bool) _value.GetStruct()["activationStateOfChannel13"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel13));
                // Simple Field (activationStateOfChannel14)
                var activationStateOfChannel14 = (bool) _value.GetStruct()["activationStateOfChannel14"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel14));
                // Simple Field (activationStateOfChannel15)
                var activationStateOfChannel15 = (bool) _value.GetStruct()["activationStateOfChannel15"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel15));
                // Simple Field (activationStateOfChannel16)
                var activationStateOfChannel16 = (bool) _value.GetStruct()["activationStateOfChannel16"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel16));
                // Simple Field (activationStateOfChannel17)
                var activationStateOfChannel17 = (bool) _value.GetStruct()["activationStateOfChannel17"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel17));
                // Simple Field (activationStateOfChannel18)
                var activationStateOfChannel18 = (bool) _value.GetStruct()["activationStateOfChannel18"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel18));
                // Simple Field (activationStateOfChannel19)
                var activationStateOfChannel19 = (bool) _value.GetStruct()["activationStateOfChannel19"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel19));
                // Simple Field (activationStateOfChannel20)
                var activationStateOfChannel20 = (bool) _value.GetStruct()["activationStateOfChannel20"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel20));
                // Simple Field (activationStateOfChannel21)
                var activationStateOfChannel21 = (bool) _value.GetStruct()["activationStateOfChannel21"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel21));
                // Simple Field (activationStateOfChannel22)
                var activationStateOfChannel22 = (bool) _value.GetStruct()["activationStateOfChannel22"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel22));
                // Simple Field (activationStateOfChannel23)
                var activationStateOfChannel23 = (bool) _value.GetStruct()["activationStateOfChannel23"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel23));
                // Simple Field (activationStateOfChannel24)
                var activationStateOfChannel24 = (bool) _value.GetStruct()["activationStateOfChannel24"].GetBool();
                writeBuffer.WriteBit("", (activationStateOfChannel24));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_HVACModeNext ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (delayTimeMin)
                var delayTimeMin = (ushort) _value.GetStruct()["delayTimeMin"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (delayTimeMin));
                // Simple Field (hvacMode)
                var hvacMode = (byte) _value.GetStruct()["hvacMode"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (hvacMode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DHWModeNext ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (delayTimeMin)
                var delayTimeMin = (ushort) _value.GetStruct()["delayTimeMin"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (delayTimeMin));
                // Simple Field (dhwMode)
                var dhwMode = (byte) _value.GetStruct()["dhwMode"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (dhwMode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_OccModeNext ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (delayTimeMin)
                var delayTimeMin = (ushort) _value.GetStruct()["delayTimeMin"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (delayTimeMin));
                // Simple Field (occupancyMode)
                var occupancyMode = (byte) _value.GetStruct()["occupancyMode"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (occupancyMode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_BuildingModeNext ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (delayTimeMin)
                var delayTimeMin = (ushort) _value.GetStruct()["delayTimeMin"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (delayTimeMin));
                // Simple Field (buildingMode)
                var buildingMode = (byte) _value.GetStruct()["buildingMode"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (buildingMode));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusLightingActuator ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (validactualvalue)
                var validactualvalue = (bool) _value.GetStruct()["validactualvalue"].GetBool();
                writeBuffer.WriteBit("", (validactualvalue));
                // Simple Field (locked)
                var locked = (bool) _value.GetStruct()["locked"].GetBool();
                writeBuffer.WriteBit("", (locked));
                // Simple Field (forced)
                var forced = (bool) _value.GetStruct()["forced"].GetBool();
                writeBuffer.WriteBit("", (forced));
                // Simple Field (nightmodeactive)
                var nightmodeactive = (bool) _value.GetStruct()["nightmodeactive"].GetBool();
                writeBuffer.WriteBit("", (nightmodeactive));
                // Simple Field (staircaselightingFunction)
                var staircaselightingFunction = (bool) _value.GetStruct()["staircaselightingFunction"].GetBool();
                writeBuffer.WriteBit("", (staircaselightingFunction));
                // Simple Field (dimming)
                var dimming = (bool) _value.GetStruct()["dimming"].GetBool();
                writeBuffer.WriteBit("", (dimming));
                // Simple Field (localoverride)
                var localoverride = (bool) _value.GetStruct()["localoverride"].GetBool();
                writeBuffer.WriteBit("", (localoverride));
                // Simple Field (failure)
                var failure = (bool) _value.GetStruct()["failure"].GetBool();
                writeBuffer.WriteBit("", (failure));
                // Simple Field (actualvalue)
                var actualvalue = (byte) _value.GetStruct()["actualvalue"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (actualvalue));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Version ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (magicNumber)
                var magicNumber = (byte) _value.GetStruct()["magicNumber"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (magicNumber));
                // Simple Field (versionNumber)
                var versionNumber = (byte) _value.GetStruct()["versionNumber"].GetByte();
                writeBuffer.WriteByte("", 5, (byte) (versionNumber));
                // Simple Field (revisionNumber)
                var revisionNumber = (byte) _value.GetStruct()["revisionNumber"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (revisionNumber));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_AlarmInfo ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (logNumber)
                var logNumber = (byte) _value.GetStruct()["logNumber"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (logNumber));
                // Simple Field (alarmPriority)
                var alarmPriority = (byte) _value.GetStruct()["alarmPriority"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (alarmPriority));
                // Simple Field (applicationArea)
                var applicationArea = (byte) _value.GetStruct()["applicationArea"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (applicationArea));
                // Simple Field (errorClass)
                var errorClass = (byte) _value.GetStruct()["errorClass"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (errorClass));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (errorcodeSup)
                var errorcodeSup = (bool) _value.GetStruct()["errorcodeSup"].GetBool();
                writeBuffer.WriteBit("", (errorcodeSup));
                // Simple Field (alarmtextSup)
                var alarmtextSup = (bool) _value.GetStruct()["alarmtextSup"].GetBool();
                writeBuffer.WriteBit("", (alarmtextSup));
                // Simple Field (timestampSup)
                var timestampSup = (bool) _value.GetStruct()["timestampSup"].GetBool();
                writeBuffer.WriteBit("", (timestampSup));
                // Simple Field (ackSup)
                var ackSup = (bool) _value.GetStruct()["ackSup"].GetBool();
                writeBuffer.WriteBit("", (ackSup));
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (locked)
                var locked = (bool) _value.GetStruct()["locked"].GetBool();
                writeBuffer.WriteBit("", (locked));
                // Simple Field (alarmunack)
                var alarmunack = (bool) _value.GetStruct()["alarmunack"].GetBool();
                writeBuffer.WriteBit("", (alarmunack));
                // Simple Field (inalarm)
                var inalarm = (bool) _value.GetStruct()["inalarm"].GetBool();
                writeBuffer.WriteBit("", (inalarm));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetF16_3 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (tempsetpcomf)
                var tempsetpcomf = (float) _value.GetStruct()["tempsetpcomf"].GetFloat();
                writeBuffer.WriteFloat("", 16,(tempsetpcomf));
                // Simple Field (tempsetpstdby)
                var tempsetpstdby = (float) _value.GetStruct()["tempsetpstdby"].GetFloat();
                writeBuffer.WriteFloat("", 16,(tempsetpstdby));
                // Simple Field (tempsetpeco)
                var tempsetpeco = (float) _value.GetStruct()["tempsetpeco"].GetFloat();
                writeBuffer.WriteFloat("", 16,(tempsetpeco));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (tempsetpshiftcomf)
                var tempsetpshiftcomf = (float) _value.GetStruct()["tempsetpshiftcomf"].GetFloat();
                writeBuffer.WriteFloat("", 16,(tempsetpshiftcomf));
                // Simple Field (tempsetpshiftstdby)
                var tempsetpshiftstdby = (float) _value.GetStruct()["tempsetpshiftstdby"].GetFloat();
                writeBuffer.WriteFloat("", 16,(tempsetpshiftstdby));
                // Simple Field (tempsetpshifteco)
                var tempsetpshifteco = (float) _value.GetStruct()["tempsetpshifteco"].GetFloat();
                writeBuffer.WriteFloat("", 16,(tempsetpshifteco));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Scaling_Speed ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (timePeriod)
                var timePeriod = (ushort) _value.GetStruct()["timePeriod"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (timePeriod));
                // Simple Field (percent)
                var percent = (byte) _value.GetStruct()["percent"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (percent));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Scaling_Step_Time ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (timePeriod)
                var timePeriod = (ushort) _value.GetStruct()["timePeriod"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (timePeriod));
                // Simple Field (percent)
                var percent = (byte) _value.GetStruct()["percent"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (percent));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_MeteringValue ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (countval)
                var countval = (int) _value.GetStruct()["countval"].GetInt();
                writeBuffer.WriteInt("", 32, (int) (countval));
                // Simple Field (valinffield)
                var valinffield = (byte) _value.GetStruct()["valinffield"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (valinffield));
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (alarmunack)
                var alarmunack = (bool) _value.GetStruct()["alarmunack"].GetBool();
                writeBuffer.WriteBit("", (alarmunack));
                // Simple Field (inalarm)
                var inalarm = (bool) _value.GetStruct()["inalarm"].GetBool();
                writeBuffer.WriteBit("", (inalarm));
                // Simple Field (overridden)
                var overridden = (bool) _value.GetStruct()["overridden"].GetBool();
                writeBuffer.WriteBit("", (overridden));
                // Simple Field (fault)
                var fault = (bool) _value.GetStruct()["fault"].GetBool();
                writeBuffer.WriteBit("", (fault));
                // Simple Field (outofservice)
                var outofservice = (bool) _value.GetStruct()["outofservice"].GetBool();
                writeBuffer.WriteBit("", (outofservice));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_MBus_Address ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (manufactid)
                var manufactid = (ushort) _value.GetStruct()["manufactid"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (manufactid));
                // Simple Field (identnumber)
                var identnumber = (uint) _value.GetStruct()["identnumber"].GetUint();
                writeBuffer.WriteUint("", 32, (uint) (identnumber));
                // Simple Field (version)
                var version = (byte) _value.GetStruct()["version"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (version));
                // Simple Field (medium)
                var medium = (byte) _value.GetStruct()["medium"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (medium));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Colour_RGB ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (r)
                var r = (byte) _value.GetStruct()["r"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (r));
                // Simple Field (g)
                var g = (byte) _value.GetStruct()["g"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (g));
                // Simple Field (b)
                var b = (byte) _value.GetStruct()["b"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (b));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII ) { // STRING
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (value)
                var value = (string) _value.GetString();
                writeBuffer.WriteString("", 16, "ASCII", (string) (value));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Tariff_ActiveEnergy ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (activeelectricalenergy)
                var activeelectricalenergy = (int) _value.GetStruct()["activeelectricalenergy"].GetInt();
                writeBuffer.WriteInt("", 32, (int) (activeelectricalenergy));
                // Simple Field (tariff)
                var tariff = (byte) _value.GetStruct()["tariff"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (tariff));
                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (electricalengergyvalidity)
                var electricalengergyvalidity = (bool) _value.GetStruct()["electricalengergyvalidity"].GetBool();
                writeBuffer.WriteBit("", (electricalengergyvalidity));
                // Simple Field (tariffvalidity)
                var tariffvalidity = (bool) _value.GetStruct()["tariffvalidity"].GetBool();
                writeBuffer.WriteBit("", (tariffvalidity));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Prioritised_Mode_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (deactivationOfPriority)
                var deactivationOfPriority = (bool) _value.GetStruct()["deactivationOfPriority"].GetBool();
                writeBuffer.WriteBit("", (deactivationOfPriority));
                // Simple Field (priorityLevel)
                var priorityLevel = (byte) _value.GetStruct()["priorityLevel"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (priorityLevel));
                // Simple Field (modeLevel)
                var modeLevel = (byte) _value.GetStruct()["modeLevel"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (modeLevel));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (convertorError)
                var convertorError = (bool) _value.GetStruct()["convertorError"].GetBool();
                writeBuffer.WriteBit("", (convertorError));
                // Simple Field (ballastFailure)
                var ballastFailure = (bool) _value.GetStruct()["ballastFailure"].GetBool();
                writeBuffer.WriteBit("", (ballastFailure));
                // Simple Field (lampFailure)
                var lampFailure = (bool) _value.GetStruct()["lampFailure"].GetBool();
                writeBuffer.WriteBit("", (lampFailure));
                // Simple Field (readOrResponse)
                var readOrResponse = (bool) _value.GetStruct()["readOrResponse"].GetBool();
                writeBuffer.WriteBit("", (readOrResponse));
                // Simple Field (addressIndicator)
                var addressIndicator = (bool) _value.GetStruct()["addressIndicator"].GetBool();
                writeBuffer.WriteBit("", (addressIndicator));
                // Simple Field (daliDeviceAddressOrDaliGroupAddress)
                var daliDeviceAddressOrDaliGroupAddress = (byte) _value.GetStruct()["daliDeviceAddressOrDaliGroupAddress"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (daliDeviceAddressOrDaliGroupAddress));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_DALI_Diagnostics ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (ballastFailure)
                var ballastFailure = (bool) _value.GetStruct()["ballastFailure"].GetBool();
                writeBuffer.WriteBit("", (ballastFailure));
                // Simple Field (lampFailure)
                var lampFailure = (bool) _value.GetStruct()["lampFailure"].GetBool();
                writeBuffer.WriteBit("", (lampFailure));
                // Simple Field (deviceAddress)
                var deviceAddress = (byte) _value.GetStruct()["deviceAddress"].GetByte();
                writeBuffer.WriteByte("", 6, (byte) (deviceAddress));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_CombinedPosition ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (heightPosition)
                var heightPosition = (byte) _value.GetStruct()["heightPosition"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (heightPosition));
                // Simple Field (slatsPosition)
                var slatsPosition = (byte) _value.GetStruct()["slatsPosition"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (slatsPosition));
                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (validitySlatsPosition)
                var validitySlatsPosition = (bool) _value.GetStruct()["validitySlatsPosition"].GetBool();
                writeBuffer.WriteBit("", (validitySlatsPosition));
                // Simple Field (validityHeightPosition)
                var validityHeightPosition = (bool) _value.GetStruct()["validityHeightPosition"].GetBool();
                writeBuffer.WriteBit("", (validityHeightPosition));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_StatusSAB ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (heightPosition)
                var heightPosition = (byte) _value.GetStruct()["heightPosition"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (heightPosition));
                // Simple Field (slatsPosition)
                var slatsPosition = (byte) _value.GetStruct()["slatsPosition"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (slatsPosition));
                // Simple Field (upperEndPosReached)
                var upperEndPosReached = (bool) _value.GetStruct()["upperEndPosReached"].GetBool();
                writeBuffer.WriteBit("", (upperEndPosReached));
                // Simple Field (lowerEndPosReached)
                var lowerEndPosReached = (bool) _value.GetStruct()["lowerEndPosReached"].GetBool();
                writeBuffer.WriteBit("", (lowerEndPosReached));
                // Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
                var lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent = (bool) _value.GetStruct()["lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent"].GetBool();
                writeBuffer.WriteBit("", (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent));
                // Simple Field (targetPosDrive)
                var targetPosDrive = (bool) _value.GetStruct()["targetPosDrive"].GetBool();
                writeBuffer.WriteBit("", (targetPosDrive));
                // Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
                var restrictionOfTargetHeightPosPosCanNotBeReached = (bool) _value.GetStruct()["restrictionOfTargetHeightPosPosCanNotBeReached"].GetBool();
                writeBuffer.WriteBit("", (restrictionOfTargetHeightPosPosCanNotBeReached));
                // Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
                var restrictionOfSlatsHeightPosPosCanNotBeReached = (bool) _value.GetStruct()["restrictionOfSlatsHeightPosPosCanNotBeReached"].GetBool();
                writeBuffer.WriteBit("", (restrictionOfSlatsHeightPosPosCanNotBeReached));
                // Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
                var atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm = (bool) _value.GetStruct()["atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm"].GetBool();
                writeBuffer.WriteBit("", (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm));
                // Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
                var upDownPositionIsForcedByMoveupdownforcedInput = (bool) _value.GetStruct()["upDownPositionIsForcedByMoveupdownforcedInput"].GetBool();
                writeBuffer.WriteBit("", (upDownPositionIsForcedByMoveupdownforcedInput));
                // Simple Field (movementIsLockedEGByDevicelockedInput)
                var movementIsLockedEGByDevicelockedInput = (bool) _value.GetStruct()["movementIsLockedEGByDevicelockedInput"].GetBool();
                writeBuffer.WriteBit("", (movementIsLockedEGByDevicelockedInput));
                // Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
                var actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface = (bool) _value.GetStruct()["actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface"].GetBool();
                writeBuffer.WriteBit("", (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface));
                // Simple Field (generalFailureOfTheActuatorOrTheDrive)
                var generalFailureOfTheActuatorOrTheDrive = (bool) _value.GetStruct()["generalFailureOfTheActuatorOrTheDrive"].GetBool();
                writeBuffer.WriteBit("", (generalFailureOfTheActuatorOrTheDrive));
                // Reserved Field
                writeBuffer.WriteByte("", 3, (byte) 0x00);
                // Simple Field (validityHeightPos)
                var validityHeightPos = (bool) _value.GetStruct()["validityHeightPos"].GetBool();
                writeBuffer.WriteBit("", (validityHeightPos));
                // Simple Field (validitySlatsPos)
                var validitySlatsPos = (bool) _value.GetStruct()["validitySlatsPos"].GetBool();
                writeBuffer.WriteBit("", (validitySlatsPos));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Colour_xyY ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (xAxis)
                var xAxis = (ushort) _value.GetStruct()["xAxis"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (xAxis));
                // Simple Field (yAxis)
                var yAxis = (ushort) _value.GetStruct()["yAxis"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (yAxis));
                // Simple Field (brightness)
                var brightness = (byte) _value.GetStruct()["brightness"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (brightness));
                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (validityXy)
                var validityXy = (bool) _value.GetStruct()["validityXy"].GetBool();
                writeBuffer.WriteBit("", (validityXy));
                // Simple Field (validityBrightness)
                var validityBrightness = (bool) _value.GetStruct()["validityBrightness"].GetBool();
                writeBuffer.WriteBit("", (validityBrightness));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Converter_Status ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
                var converterModeAccordingToTheDaliConverterStateMachine = (byte) _value.GetStruct()["converterModeAccordingToTheDaliConverterStateMachine"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (converterModeAccordingToTheDaliConverterStateMachine));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (hardwiredSwitchIsActive)
                var hardwiredSwitchIsActive = (bool) _value.GetStruct()["hardwiredSwitchIsActive"].GetBool();
                writeBuffer.WriteBit("", (hardwiredSwitchIsActive));
                // Simple Field (hardwiredInhibitIsActive)
                var hardwiredInhibitIsActive = (bool) _value.GetStruct()["hardwiredInhibitIsActive"].GetBool();
                writeBuffer.WriteBit("", (hardwiredInhibitIsActive));
                // Simple Field (functionTestPending)
                var functionTestPending = (byte) _value.GetStruct()["functionTestPending"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (functionTestPending));
                // Simple Field (durationTestPending)
                var durationTestPending = (byte) _value.GetStruct()["durationTestPending"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (durationTestPending));
                // Simple Field (partialDurationTestPending)
                var partialDurationTestPending = (byte) _value.GetStruct()["partialDurationTestPending"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (partialDurationTestPending));
                // Simple Field (converterFailure)
                var converterFailure = (byte) _value.GetStruct()["converterFailure"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (converterFailure));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Converter_Test_Result ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (ltrf)
                var ltrf = (byte) _value.GetStruct()["ltrf"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (ltrf));
                // Simple Field (ltrd)
                var ltrd = (byte) _value.GetStruct()["ltrd"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (ltrd));
                // Simple Field (ltrp)
                var ltrp = (byte) _value.GetStruct()["ltrp"].GetByte();
                writeBuffer.WriteByte("", 4, (byte) (ltrp));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (sf)
                var sf = (byte) _value.GetStruct()["sf"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (sf));
                // Simple Field (sd)
                var sd = (byte) _value.GetStruct()["sd"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (sd));
                // Simple Field (sp)
                var sp = (byte) _value.GetStruct()["sp"].GetByte();
                writeBuffer.WriteByte("", 2, (byte) (sp));
                // Reserved Field
                writeBuffer.WriteByte("", 2, (byte) 0x00);
                // Simple Field (ldtr)
                var ldtr = (ushort) _value.GetStruct()["ldtr"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (ldtr));
                // Simple Field (lpdtr)
                var lpdtr = (byte) _value.GetStruct()["lpdtr"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (lpdtr));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Battery_Info ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (batteryFailure)
                var batteryFailure = (bool) _value.GetStruct()["batteryFailure"].GetBool();
                writeBuffer.WriteBit("", (batteryFailure));
                // Simple Field (batteryDurationFailure)
                var batteryDurationFailure = (bool) _value.GetStruct()["batteryDurationFailure"].GetBool();
                writeBuffer.WriteBit("", (batteryDurationFailure));
                // Simple Field (batteryFullyCharged)
                var batteryFullyCharged = (bool) _value.GetStruct()["batteryFullyCharged"].GetBool();
                writeBuffer.WriteBit("", (batteryFullyCharged));
                // Simple Field (batteryChargeLevel)
                var batteryChargeLevel = (byte) _value.GetStruct()["batteryChargeLevel"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (batteryChargeLevel));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (ms)
                var ms = (ushort) _value.GetStruct()["ms"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (ms));
                // Simple Field (temperatureK)
                var temperatureK = (ushort) _value.GetStruct()["temperatureK"].GetUshort();
                writeBuffer.WriteUshort("", 16, (ushort) (temperatureK));
                // Simple Field (percent)
                var percent = (byte) _value.GetStruct()["percent"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (percent));
                // Reserved Field
                writeBuffer.WriteByte("", 5, (byte) 0x00);
                // Simple Field (validityOfTheTimePeriod)
                var validityOfTheTimePeriod = (bool) _value.GetStruct()["validityOfTheTimePeriod"].GetBool();
                writeBuffer.WriteBit("", (validityOfTheTimePeriod));
                // Simple Field (validityOfTheAbsoluteColourTemperature)
                var validityOfTheAbsoluteColourTemperature = (bool) _value.GetStruct()["validityOfTheAbsoluteColourTemperature"].GetBool();
                writeBuffer.WriteBit("", (validityOfTheAbsoluteColourTemperature));
                // Simple Field (validityOfTheAbsoluteBrightness)
                var validityOfTheAbsoluteBrightness = (bool) _value.GetStruct()["validityOfTheAbsoluteBrightness"].GetBool();
                writeBuffer.WriteBit("", (validityOfTheAbsoluteBrightness));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Brightness_Colour_Temperature_Control ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cct)
                var cct = (bool) _value.GetStruct()["cct"].GetBool();
                writeBuffer.WriteBit("", (cct));
                // Simple Field (stepCodeColourTemperature)
                var stepCodeColourTemperature = (byte) _value.GetStruct()["stepCodeColourTemperature"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourTemperature));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cb)
                var cb = (bool) _value.GetStruct()["cb"].GetBool();
                writeBuffer.WriteBit("", (cb));
                // Simple Field (stepCodeBrightness)
                var stepCodeBrightness = (byte) _value.GetStruct()["stepCodeBrightness"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeBrightness));
                // Reserved Field
                writeBuffer.WriteByte("", 6, (byte) 0x00);
                // Simple Field (cctAndStepCodeColourValidity)
                var cctAndStepCodeColourValidity = (bool) _value.GetStruct()["cctAndStepCodeColourValidity"].GetBool();
                writeBuffer.WriteBit("", (cctAndStepCodeColourValidity));
                // Simple Field (cbAndStepCodeBrightnessValidity)
                var cbAndStepCodeBrightnessValidity = (bool) _value.GetStruct()["cbAndStepCodeBrightnessValidity"].GetBool();
                writeBuffer.WriteBit("", (cbAndStepCodeBrightnessValidity));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Colour_RGBW ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (colourLevelRed)
                var colourLevelRed = (byte) _value.GetStruct()["colourLevelRed"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (colourLevelRed));
                // Simple Field (colourLevelGreen)
                var colourLevelGreen = (byte) _value.GetStruct()["colourLevelGreen"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (colourLevelGreen));
                // Simple Field (colourLevelBlue)
                var colourLevelBlue = (byte) _value.GetStruct()["colourLevelBlue"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (colourLevelBlue));
                // Simple Field (colourLevelWhite)
                var colourLevelWhite = (byte) _value.GetStruct()["colourLevelWhite"].GetByte();
                writeBuffer.WriteByte("", 8, (byte) (colourLevelWhite));
                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (mr)
                var mr = (bool) _value.GetStruct()["mr"].GetBool();
                writeBuffer.WriteBit("", (mr));
                // Simple Field (mg)
                var mg = (bool) _value.GetStruct()["mg"].GetBool();
                writeBuffer.WriteBit("", (mg));
                // Simple Field (mb)
                var mb = (bool) _value.GetStruct()["mb"].GetBool();
                writeBuffer.WriteBit("", (mb));
                // Simple Field (mw)
                var mw = (bool) _value.GetStruct()["mw"].GetBool();
                writeBuffer.WriteBit("", (mw));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Relative_Control_RGBW ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (maskcw)
                var maskcw = (bool) _value.GetStruct()["maskcw"].GetBool();
                writeBuffer.WriteBit("", (maskcw));
                // Simple Field (maskcb)
                var maskcb = (bool) _value.GetStruct()["maskcb"].GetBool();
                writeBuffer.WriteBit("", (maskcb));
                // Simple Field (maskcg)
                var maskcg = (bool) _value.GetStruct()["maskcg"].GetBool();
                writeBuffer.WriteBit("", (maskcg));
                // Simple Field (maskcr)
                var maskcr = (bool) _value.GetStruct()["maskcr"].GetBool();
                writeBuffer.WriteBit("", (maskcr));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cw)
                var cw = (bool) _value.GetStruct()["cw"].GetBool();
                writeBuffer.WriteBit("", (cw));
                // Simple Field (stepCodeColourWhite)
                var stepCodeColourWhite = (byte) _value.GetStruct()["stepCodeColourWhite"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourWhite));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cb)
                var cb = (bool) _value.GetStruct()["cb"].GetBool();
                writeBuffer.WriteBit("", (cb));
                // Simple Field (stepCodeColourBlue)
                var stepCodeColourBlue = (byte) _value.GetStruct()["stepCodeColourBlue"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourBlue));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cg)
                var cg = (bool) _value.GetStruct()["cg"].GetBool();
                writeBuffer.WriteBit("", (cg));
                // Simple Field (stepCodeColourGreen)
                var stepCodeColourGreen = (byte) _value.GetStruct()["stepCodeColourGreen"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourGreen));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cr)
                var cr = (bool) _value.GetStruct()["cr"].GetBool();
                writeBuffer.WriteBit("", (cr));
                // Simple Field (stepCodeColourRed)
                var stepCodeColourRed = (byte) _value.GetStruct()["stepCodeColourRed"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourRed));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_Relative_Control_RGB ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cb)
                var cb = (bool) _value.GetStruct()["cb"].GetBool();
                writeBuffer.WriteBit("", (cb));
                // Simple Field (stepCodeColourBlue)
                var stepCodeColourBlue = (byte) _value.GetStruct()["stepCodeColourBlue"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourBlue));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cg)
                var cg = (bool) _value.GetStruct()["cg"].GetBool();
                writeBuffer.WriteBit("", (cg));
                // Simple Field (stepCodeColourGreen)
                var stepCodeColourGreen = (byte) _value.GetStruct()["stepCodeColourGreen"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourGreen));
                // Reserved Field
                writeBuffer.WriteByte("", 4, (byte) 0x00);
                // Simple Field (cr)
                var cr = (bool) _value.GetStruct()["cr"].GetBool();
                writeBuffer.WriteBit("", (cr));
                // Simple Field (stepCodeColourRed)
                var stepCodeColourRed = (byte) _value.GetStruct()["stepCodeColourRed"].GetByte();
                writeBuffer.WriteByte("", 3, (byte) (stepCodeColourRed));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_GeographicalLocation ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (longitude)
                var longitude = (float) _value.GetStruct()["longitude"].GetFloat();
                writeBuffer.WriteFloat("", 32,(longitude));
                // Simple Field (latitude)
                var latitude = (float) _value.GetStruct()["latitude"].GetFloat();
                writeBuffer.WriteFloat("", 32,(latitude));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetF16_4 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (roomTemperatureSetpointComfort)
                var roomTemperatureSetpointComfort = (float) _value.GetStruct()["roomTemperatureSetpointComfort"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointComfort));
                // Simple Field (roomTemperatureSetpointStandby)
                var roomTemperatureSetpointStandby = (float) _value.GetStruct()["roomTemperatureSetpointStandby"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointStandby));
                // Simple Field (roomTemperatureSetpointEconomy)
                var roomTemperatureSetpointEconomy = (float) _value.GetStruct()["roomTemperatureSetpointEconomy"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointEconomy));
                // Simple Field (roomTemperatureSetpointBuildingProtection)
                var roomTemperatureSetpointBuildingProtection = (float) _value.GetStruct()["roomTemperatureSetpointBuildingProtection"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointBuildingProtection));
            return writeBuffer;
        } if( datapointType == KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4 ) { // Struct
                var writeBuffer = new WriteBuffer();

                // Reserved Field
                writeBuffer.WriteByte("", 8, (byte) 0x00);
                // Simple Field (roomTemperatureSetpointShiftComfort)
                var roomTemperatureSetpointShiftComfort = (float) _value.GetStruct()["roomTemperatureSetpointShiftComfort"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointShiftComfort));
                // Simple Field (roomTemperatureSetpointShiftStandby)
                var roomTemperatureSetpointShiftStandby = (float) _value.GetStruct()["roomTemperatureSetpointShiftStandby"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointShiftStandby));
                // Simple Field (roomTemperatureSetpointShiftEconomy)
                var roomTemperatureSetpointShiftEconomy = (float) _value.GetStruct()["roomTemperatureSetpointShiftEconomy"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointShiftEconomy));
                // Simple Field (roomTemperatureSetpointShiftBuildingProtection)
                var roomTemperatureSetpointShiftBuildingProtection = (float) _value.GetStruct()["roomTemperatureSetpointShiftBuildingProtection"].GetFloat();
                writeBuffer.WriteFloat("", 16,(roomTemperatureSetpointShiftBuildingProtection));
            return writeBuffer;
        } 
        return null;
        }
    }

}
