/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.codec;

import com.alipay.remoting.Connection;
import com.alipay.remoting.Protocol;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.ProtocolManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.Attribute;
import java.io.Serializable;

@ChannelHandler.Sharable
public class ProtocolCodeBasedEncoder
extends MessageToByteEncoder<Serializable> {
    protected ProtocolCode defaultProtocolCode;

    public ProtocolCodeBasedEncoder(ProtocolCode defaultProtocolCode) {
        this.defaultProtocolCode = defaultProtocolCode;
    }

    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        Attribute att = ctx.channel().attr(Connection.PROTOCOL);
        ProtocolCode protocolCode = att == null || att.get() == null ? this.defaultProtocolCode : (ProtocolCode)att.get();
        Protocol protocol = ProtocolManager.getProtocol(protocolCode);
        protocol.getEncoder().encode(ctx, msg, out);
    }
}

