/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.stats;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.stats.MomentStatsItem;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class MomentStatsItemSet {
    private static final Logger COMMERCIAL_LOG = LoggerFactory.getLogger((String)"RocketmqCommercial");
    private final ConcurrentMap<String, MomentStatsItem> statsItemTable = new ConcurrentHashMap<String, MomentStatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Logger log;

    public MomentStatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, Logger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    public ConcurrentMap<String, MomentStatsItem> getStatsItemTable() {
        return this.statsItemTable;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MomentStatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computeNextMinutesTimeMillis() - System.currentTimeMillis()), 300000L, TimeUnit.MILLISECONDS);
    }

    private void printAtMinutes() {
        for (Map.Entry next : this.statsItemTable.entrySet()) {
            ((MomentStatsItem)next.getValue()).printAtMinutes();
        }
    }

    public void setValue(String statsKey, int value) {
        MomentStatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().set(value);
        statsItem.setLastUpdateTimestamp(System.currentTimeMillis());
    }

    public void setValue(String statsKey, long value) {
        MomentStatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().set(value);
        statsItem.setLastUpdateTimestamp(System.currentTimeMillis());
    }

    public void delValueByInfixKey(String statsKey, String separator) {
        Iterator it = this.statsItemTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!((String)next.getKey()).contains(separator + statsKey + separator)) continue;
            it.remove();
        }
    }

    public void delValueBySuffixKey(String statsKey, String separator) {
        Iterator it = this.statsItemTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!((String)next.getKey()).endsWith(separator + statsKey)) continue;
            it.remove();
        }
    }

    public MomentStatsItem getAndCreateStatsItem(String statsKey) {
        MomentStatsItem prev;
        MomentStatsItem statsItem = (MomentStatsItem)this.statsItemTable.get(statsKey);
        if (null == statsItem && null != (prev = this.statsItemTable.putIfAbsent(statsKey, statsItem = new MomentStatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            statsItem = prev;
        }
        return statsItem;
    }

    public void cleanResource(int maxStatsIdleTimeInMinutes) {
        COMMERCIAL_LOG.info("CleanStatisticItem: kind:{}, size:{}", (Object)this.statsName, (Object)this.statsItemTable.size());
        Iterator it = this.statsItemTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            MomentStatsItem statsItem = (MomentStatsItem)next.getValue();
            if (System.currentTimeMillis() - statsItem.getLastUpdateTimestamp() <= (long)(maxStatsIdleTimeInMinutes * 60) * 1000L) continue;
            it.remove();
            COMMERCIAL_LOG.info("CleanStatisticItem: removeKind:{}, removeKey:{}", (Object)this.statsName, (Object)statsItem.getStatsKey());
        }
    }
}

