/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.common.Attributes;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.pagecache.OneMessageTransfer;
import org.apache.rocketmq.broker.pagecache.QueryMessageTransfer;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.metrics.RemotingMetricsManager;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.QueryMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.ViewMessageRequestHeader;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class QueryMessageProcessor
implements NettyRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;

    public QueryMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 12: {
                return this.queryMessage(ctx, request);
            }
            case 33: {
                return this.viewMessageById(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand queryMessage(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryMessageResponseHeader.class);
        QueryMessageResponseHeader responseHeader = (QueryMessageResponseHeader)response.readCustomHeader();
        QueryMessageRequestHeader requestHeader = (QueryMessageRequestHeader)request.decodeCommandCustomHeader(QueryMessageRequestHeader.class);
        response.setOpaque(request.getOpaque());
        String indexType = requestHeader.getIndexType();
        String lastKey = requestHeader.getLastKey();
        String isUniqueKey = null;
        if (null != request.getExtFields()) {
            isUniqueKey = (String)request.getExtFields().get("_UNIQUE_KEY_QUERY");
        }
        if (!StringUtils.isEmpty(isUniqueKey) && Boolean.parseBoolean(isUniqueKey)) {
            requestHeader.setMaxNum(Integer.valueOf(this.brokerController.getMessageStoreConfig().getDefaultQueryMaxNum()));
            indexType = "U";
        } else if (StringUtils.isEmpty((CharSequence)indexType)) {
            indexType = "K";
        }
        QueryMessageResult queryMessageResult = this.brokerController.getMessageStore().queryMessage(requestHeader.getTopic(), requestHeader.getKey(), requestHeader.getMaxNum().intValue(), requestHeader.getBeginTimestamp().longValue(), requestHeader.getEndTimestamp().longValue(), indexType, lastKey);
        assert (queryMessageResult != null);
        responseHeader.setIndexLastUpdatePhyoffset(Long.valueOf(queryMessageResult.getIndexLastUpdatePhyoffset()));
        responseHeader.setIndexLastUpdateTimestamp(Long.valueOf(queryMessageResult.getIndexLastUpdateTimestamp()));
        if (queryMessageResult.getBufferTotalSize() > 0) {
            response.setCode(0);
            response.setRemark(null);
            try {
                QueryMessageTransfer fileRegion = new QueryMessageTransfer(response.encodeHeader(queryMessageResult.getBufferTotalSize()), queryMessageResult);
                ctx.channel().writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    queryMessageResult.release();
                    RemotingMetricsManager remotingMetricsManager = this.brokerController.getBrokerMetricsManager().getRemotingMetricsManager();
                    Attributes attributes = remotingMetricsManager.newAttributesBuilder().put("request_code", RemotingHelper.getRequestCodeDesc((int)request.getCode())).put("response_code", RemotingHelper.getResponseCodeDesc((int)response.getCode())).put("result", remotingMetricsManager.getWriteAndFlushResult(future)).build();
                    remotingMetricsManager.getRpcLatency().record(request.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributes);
                    if (!future.isSuccess()) {
                        LOGGER.error("transfer query message by page cache failed, ", future.cause());
                    }
                }));
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                queryMessageResult.release();
            }
            return null;
        }
        response.setCode(22);
        response.setRemark("can not find message, maybe time range not correct");
        return response;
    }

    public RemotingCommand viewMessageById(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ViewMessageRequestHeader requestHeader = (ViewMessageRequestHeader)request.decodeCommandCustomHeader(ViewMessageRequestHeader.class);
        response.setOpaque(request.getOpaque());
        SelectMappedBufferResult selectMappedBufferResult = this.brokerController.getMessageStore().selectOneMessageByOffset(requestHeader.getOffset().longValue());
        if (selectMappedBufferResult != null) {
            response.setCode(0);
            response.setRemark(null);
            try {
                OneMessageTransfer fileRegion = new OneMessageTransfer(response.encodeHeader(selectMappedBufferResult.getSize()), selectMappedBufferResult);
                ctx.channel().writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    selectMappedBufferResult.release();
                    RemotingMetricsManager remotingMetricsManager = this.brokerController.getBrokerMetricsManager().getRemotingMetricsManager();
                    Attributes attributes = remotingMetricsManager.newAttributesBuilder().put("request_code", RemotingHelper.getRequestCodeDesc((int)request.getCode())).put("response_code", RemotingHelper.getResponseCodeDesc((int)response.getCode())).put("result", remotingMetricsManager.getWriteAndFlushResult(future)).build();
                    remotingMetricsManager.getRpcLatency().record(request.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributes);
                    if (!future.isSuccess()) {
                        LOGGER.error("Transfer one message from page cache failed, ", future.cause());
                    }
                }));
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                selectMappedBufferResult.release();
            }
            return null;
        }
        response.setCode(1);
        response.setRemark("can not find message by the offset, " + requestHeader.getOffset());
        return response;
    }
}

