/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamJsonWriter
implements JsonWriter {
    public static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final Logger internalLogger = Logger.getLogger(StreamJsonWriter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final String type;
    private final OutputStream outputStream;

    public StreamJsonWriter(OutputStream originalStream, String type) {
        this.outputStream = originalStream;
        this.type = type;
    }

    @Override
    public CompletableResultCode write(Marshaler exportRequest) {
        try {
            exportRequest.writeJsonWithNewline(JSON_FACTORY.createGenerator(this.outputStream).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Unable to write OTLP JSON " + this.type, (Throwable)e);
            return CompletableResultCode.ofFailure();
        }
    }

    @Override
    public CompletableResultCode flush() {
        try {
            this.outputStream.flush();
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to flush items", (Throwable)e);
            return CompletableResultCode.ofFailure();
        }
    }

    @Override
    public CompletableResultCode close() {
        if (this.outputStream == System.out || this.outputStream == System.err) {
            return CompletableResultCode.ofSuccess();
        }
        try {
            this.outputStream.close();
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to close stream", (Throwable)e);
            return CompletableResultCode.ofFailure();
        }
    }

    public String toString() {
        return "StreamJsonWriter{outputStream=" + StreamJsonWriter.getName(this.outputStream) + '}';
    }

    private static String getName(OutputStream outputStream) {
        if (outputStream == System.out) {
            return "stdout";
        }
        if (outputStream == System.err) {
            return "stderr";
        }
        return outputStream.toString();
    }
}

