/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.http.HttpServerRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.tracing.zipkin.InvocationAware;
import org.apache.servicecomb.tracing.zipkin.TracingConfiguration;

class HttpServeRequestWrapper
extends HttpServerRequest
implements InvocationAware {
    private final Invocation invocation;

    HttpServeRequestWrapper(Invocation invocation) {
        this.invocation = invocation;
    }

    public String method() {
        return this.invocation.getOperationMeta().getHttpMethod();
    }

    public String path() {
        return TracingConfiguration.createRequestPath(this.invocation);
    }

    public String url() {
        return this.invocation.getInvocationQualifiedName();
    }

    public String route() {
        return this.invocation.getRequestEx() != null ? this.invocation.getRequestEx().getRemoteAddr() : null;
    }

    public String header(String name) {
        String result = this.invocation.getContext(name);
        if (StringUtils.isEmpty((CharSequence)result) && this.invocation.getRequestEx() != null) {
            result = this.invocation.getRequestEx().getHeader(name);
        }
        return result;
    }

    public Object unwrap() {
        return this.invocation;
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }
}

