/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Menu;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.internal.NonNullObjectProperty;
import org.apache.sis.gui.internal.RecentChoices;
import org.apache.sis.gui.internal.io.OptionalDataDownloader;
import org.apache.sis.gui.referencing.CRSChooser;
import org.apache.sis.gui.referencing.MenuSync;
import org.apache.sis.gui.referencing.ObjectStringConverter;
import org.apache.sis.gui.referencing.Utils;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.GazetteerFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class RecentReferenceSystems {
    private static final int NUM_CORE_ITEMS = 1;
    private static final int NUM_SHOWN_ITEMS = 9;
    private static final int NUM_OTHER_ITEMS = 1;
    private static final String SELECTED_ITEM_KEY = "SelectedItem";
    static final ReferenceSystem OTHER = null;
    private volatile CRSAuthorityFactory factory;
    public final ObjectProperty<Envelope> areaOfInterest;
    private ImmutableEnvelope geographicAOI;
    public final ObjectProperty<ComparisonMode> duplicationCriterion;
    private final List<WritableValue<ReferenceSystem>> controlValues;
    final Locale locale;
    private final List<Object> systemsOrCodes;
    private ObservableList<ReferenceSystem> referenceSystems;
    private ObservableList<ReferenceSystem> coordinateReferenceSystems;
    private ObservableList<ReferenceSystem> publicItemList;
    private final List<DerivedCRS> cellIndiceSystems;
    private boolean isModified;
    private boolean isAdjusting;

    public RecentReferenceSystems() {
        this(null, null);
    }

    public RecentReferenceSystems(CRSAuthorityFactory factory, Locale locale) {
        this.factory = factory;
        this.locale = locale;
        this.systemsOrCodes = new ArrayList<Object>();
        this.cellIndiceSystems = new ArrayList<DerivedCRS>();
        this.areaOfInterest = new SimpleObjectProperty((Object)this, "areaOfInterest");
        this.duplicationCriterion = new NonNullObjectProperty<ComparisonMode>(this, "duplicationCriterion", ComparisonMode.ALLOW_VARIANT);
        this.controlValues = new ArrayList<WritableValue<ReferenceSystem>>();
        this.duplicationCriterion.addListener(e -> this.listModified());
        this.areaOfInterest.addListener((e, o, n) -> {
            this.geographicAOI = Utils.toGeographic(RecentReferenceSystems.class, "areaOfInterest", n);
            this.listModified();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGridReferencing(boolean replaceByAuthoritativeDefinition, Map<String, GridGeometry> geometries) {
        int countEnv = 0;
        int countCRS = 0;
        int countCIR = 0;
        Envelope[] envelopes = new Envelope[geometries.size()];
        Object[] derived = new DerivedCRS[geometries.size()];
        CoordinateReferenceSystem[] alt = new CoordinateReferenceSystem[Math.max(derived.length - 1, 0)];
        CoordinateReferenceSystem preferred = null;
        for (Map.Entry<String, GridGeometry> entry : geometries.entrySet()) {
            GridGeometry gg = entry.getValue();
            if (gg.isDefined(2)) {
                envelopes[countEnv++] = gg.getEnvelope();
            }
            if (!gg.isDefined(1)) continue;
            CoordinateReferenceSystem crs = gg.getCoordinateReferenceSystem();
            if (preferred == null) {
                preferred = crs;
            } else {
                alt[countCRS++] = crs;
            }
            if (!gg.isDefined(12)) continue;
            derived[countCIR++] = gg.createImageCRS(entry.getKey(), PixelInCell.CELL_CENTER);
        }
        GeneralEnvelope aoi = null;
        try {
            aoi = Envelopes.union((Envelope[])envelopes);
        }
        catch (TransformException e) {
            RecentReferenceSystems.errorOccurred("setGridReferencing", (Exception)((Object)e));
        }
        ObservableList<ReferenceSystem> savedReferenceSystemList = this.referenceSystems;
        try {
            this.referenceSystems = null;
            if (preferred != null) {
                this.setPreferred(replaceByAuthoritativeDefinition, (ReferenceSystem)preferred);
                this.addAlternatives(replaceByAuthoritativeDefinition, (ReferenceSystem[])alt);
                this.cellIndiceSystems.clear();
                this.cellIndiceSystems.addAll((Collection<DerivedCRS>)UnmodifiableArrayList.wrap((Object[])derived, (int)0, (int)countCIR));
            }
            this.areaOfInterest.set((Object)aoi);
        }
        finally {
            this.referenceSystems = savedReferenceSystemList;
        }
        this.listModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPreferred(boolean replaceByAuthoritativeDefinition, ReferenceSystem system) {
        ArgumentChecks.ensureNonNull((String)"system", (Object)system);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.systemsOrCodes.add(0, replaceByAuthoritativeDefinition ? new Unverified(system) : system);
            this.listModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferred(String code) {
        ArgumentChecks.ensureNonEmpty((String)"code", (CharSequence)code);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.systemsOrCodes.add(0, code);
            this.listModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addSelected(ReferenceSystem system) {
        if (RecentReferenceSystems.isAccepted((IdentifiedObject)system)) {
            List<Object> list = this.systemsOrCodes;
            synchronized (list) {
                this.systemsOrCodes.add(Math.min(this.systemsOrCodes.size(), 1), system);
                this.listModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAlternatives(boolean replaceByAuthoritativeDefinition, ReferenceSystem ... systems) {
        ArgumentChecks.ensureNonNull((String)"systems", (Object)systems);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            for (ReferenceSystem system : systems) {
                if (system == null) continue;
                this.systemsOrCodes.add(replaceByAuthoritativeDefinition ? new Unverified(system) : system);
            }
            this.listModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternatives(String ... codes) {
        ArgumentChecks.ensureNonNull((String)"codes", (Object)codes);
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            for (String code : codes) {
                if ((code = Strings.trimOrNull((String)code)) == null) continue;
                this.systemsOrCodes.add(code);
            }
            this.listModified();
        }
    }

    public void addUserPreferences() {
        this.addAlternatives(RecentChoices.getReferenceSystems());
    }

    private static boolean isAccepted(IdentifiedObject object) {
        return IdentifiedObjects.getIdentifier((IdentifiedObject)object, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceSystem> filterReferenceSystems(ImmutableEnvelope domain, ComparisonMode mode) {
        ArrayList<ReferenceSystem> systems;
        GazetteerFactory gf = new GazetteerFactory();
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            int j;
            ReferenceSystem system;
            CRSAuthorityFactory factory = this.factory;
            if (!this.isModified) {
                return null;
            }
            boolean noFactoryFound = false;
            boolean searchedFinder = false;
            IdentifiedObjectFinder finder = null;
            int i = this.systemsOrCodes.size();
            while (--i >= 0) {
                Object item = this.systemsOrCodes.get(i);
                if (item instanceof ReferenceSystem) continue;
                system = null;
                if (item != OTHER) {
                    try {
                        if (item instanceof String) {
                            system = gf.forNameIfKnown((String)item).orElse(null);
                            if (system == null && !noFactoryFound) {
                                if (factory == null) {
                                    factory = Utils.getDefaultFactory();
                                }
                                system = factory.createCoordinateReferenceSystem((String)item);
                            }
                        } else if (item instanceof Unverified) {
                            if (!searchedFinder) {
                                searchedFinder = true;
                                finder = factory instanceof GeodeticAuthorityFactory ? ((GeodeticAuthorityFactory)factory).newIdentifiedObjectFinder() : IdentifiedObjects.newFinder(null);
                                finder.setIgnoringAxes(true);
                            }
                            system = ((Unverified)item).find(finder);
                        }
                    }
                    catch (FactoryException e) {
                        this.errorOccurred(e);
                        noFactoryFound = factory == null;
                    }
                    catch (GazetteerException e) {
                        RecentReferenceSystems.errorOccurred("getReferenceSystems", (Exception)((Object)e));
                    }
                }
                if (system != null) {
                    this.systemsOrCodes.set(i, system);
                    continue;
                }
                this.systemsOrCodes.remove(i);
            }
            for (i = 0; i < (j = this.systemsOrCodes.size()); ++i) {
                if (i >= 20) {
                    this.systemsOrCodes.subList(i, j).clear();
                    break;
                }
                Object item = this.systemsOrCodes.get(i);
                while (--j > i) {
                    Object removed;
                    if (!Utilities.deepEquals((Object)item, (Object)this.systemsOrCodes.get(j), (ComparisonMode)mode) || !RecentReferenceSystems.isAccepted((IdentifiedObject)(removed = this.systemsOrCodes.remove(j))) || RecentReferenceSystems.isAccepted((IdentifiedObject)item)) continue;
                    item = removed;
                    this.systemsOrCodes.set(i, item);
                }
            }
            int n = this.systemsOrCodes.size();
            systems = new ArrayList<ReferenceSystem>(Math.min(9, n) + 1);
            for (int i2 = 0; i2 < n; ++i2) {
                system = (ReferenceSystem)this.systemsOrCodes.get(i2);
                if (i2 >= 1 && !Utils.intersects(domain, system) || Utils.isIgnoreable(system)) continue;
                systems.add(system);
                if (systems.size() >= 9) break;
            }
            systems.add(OTHER);
            this.isModified = false;
            this.factory = factory;
        }
        return systems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listModified() {
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            this.isModified = true;
            if (this.referenceSystems != null) {
                this.getReferenceSystems(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObservableList<ReferenceSystem> getReferenceSystems(boolean filtered) {
        if (this.referenceSystems == null) {
            this.referenceSystems = FXCollections.observableArrayList();
        }
        List<Object> list = this.systemsOrCodes;
        synchronized (list) {
            if (this.isModified) {
                int insertAt = Math.min(this.systemsOrCodes.size(), 1);
                List<ReferenceSystem> selected = this.getSelectedItems();
                this.systemsOrCodes.addAll(insertAt, selected);
                this.systemsOrCodes.addAll(insertAt + selected.size(), (Collection<Object>)this.referenceSystems);
                final ImmutableEnvelope domain = this.geographicAOI;
                final ComparisonMode mode = (ComparisonMode)this.duplicationCriterion.get();
                BackgroundThreads.execute((Runnable)new Task<List<ReferenceSystem>>(this){
                    final /* synthetic */ RecentReferenceSystems this$0;
                    {
                        this.this$0 = this$0;
                    }

                    protected List<ReferenceSystem> call() {
                        return this.this$0.filterReferenceSystems(domain, mode);
                    }

                    protected void failed() {
                        ExceptionReporter.show(null, this);
                    }

                    protected void succeeded() {
                        this.this$0.setReferenceSystems((List)this.getValue(), mode);
                    }
                });
            }
        }
        if (filtered) {
            if (this.coordinateReferenceSystems == null) {
                this.coordinateReferenceSystems = new FilteredList(this.referenceSystems, RecentReferenceSystems::isCRS);
            }
            return this.coordinateReferenceSystems;
        }
        return this.referenceSystems;
    }

    private static boolean isCRS(ReferenceSystem system) {
        return system == OTHER || system instanceof CoordinateReferenceSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReferenceSystems(List<ReferenceSystem> systems, ComparisonMode mode) {
        if (systems != null && !this.isAdjusting) {
            try {
                this.isAdjusting = true;
                ReferenceSystem[] values = (ReferenceSystem[])this.controlValues.stream().map(WritableValue::getValue).toArray(ReferenceSystem[]::new);
                if (GUIUtilities.copyAsDiff(systems, this.referenceSystems)) {
                    this.notifyChanges();
                }
                int n = this.referenceSystems.size();
                for (int j = 0; j < values.length; ++j) {
                    ReferenceSystem system = values[j];
                    if (system == null) continue;
                    for (int i = 0; i < n; ++i) {
                        ReferenceSystem candidate = (ReferenceSystem)this.referenceSystems.get(i);
                        if (!Utilities.deepEquals((Object)candidate, (Object)system, (ComparisonMode)mode)) continue;
                        system = candidate;
                        break;
                    }
                    this.controlValues.get(j).setValue((Object)system);
                }
            }
            finally {
                this.isAdjusting = false;
            }
        }
    }

    private void notifyChanges() {
        for (WritableValue<ReferenceSystem> value : this.controlValues) {
            if (!(value instanceof MenuSync)) continue;
            ((MenuSync)value).notifyChanges();
        }
    }

    public ObservableList<ReferenceSystem> getItems() {
        if (this.publicItemList == null) {
            this.publicItemList = new FilteredList(this.getReferenceSystems(false), Objects::nonNull);
        }
        return this.publicItemList;
    }

    /*
     * WARNING - void declaration
     */
    public List<ReferenceSystem> getSelectedItems() {
        ReferenceSystem system2;
        int count = 0;
        ReferenceSystem[] selected = new ReferenceSystem[this.controlValues.size()];
        for (WritableValue<ReferenceSystem> writableValue : this.controlValues) {
            system2 = (ReferenceSystem)writableValue.getValue();
            if (system2 == null) continue;
            selected[count++] = system2;
        }
        ArrayList<ReferenceSystem> ordered = new ArrayList<ReferenceSystem>(count);
        if (count != 0) {
            void var4_7;
            block1: for (ReferenceSystem system2 : this.referenceSystems) {
                if (system2 == OTHER) continue;
                for (int i = 0; i < count; ++i) {
                    if (selected[i] != system2) continue;
                    ordered.add(system2);
                    if (--count == 0) {
                        return ordered;
                    }
                    System.arraycopy(selected, i + 1, selected, i, count - i);
                    continue block1;
                }
            }
            boolean bl = false;
            while (var4_7 < count) {
                block7: {
                    system2 = selected[var4_7];
                    int j = ordered.size();
                    while (--j >= 0) {
                        if (ordered.get(j) != system2) continue;
                        break block7;
                    }
                    ordered.add(system2);
                }
                ++var4_7;
            }
        }
        return ordered;
    }

    public ChoiceBox<ReferenceSystem> createChoiceBox(boolean filtered, ChangeListener<ReferenceSystem> action) {
        ArgumentChecks.ensureNonNull((String)"action", action);
        ChoiceBox choices = new ChoiceBox(this.getReferenceSystems(filtered));
        choices.setConverter(new ObjectStringConverter(choices.getItems(), this.locale));
        choices.valueProperty().addListener((ChangeListener)new SelectionListener(action));
        this.controlValues.add((WritableValue<ReferenceSystem>)choices.valueProperty());
        return choices;
    }

    public Menu createMenuItems(boolean filtered, ChangeListener<ReferenceSystem> action) {
        ArgumentChecks.ensureNonNull((String)"action", action);
        ObservableList<ReferenceSystem> main = this.getReferenceSystems(filtered);
        List<DerivedCRS> derived = filtered ? null : this.cellIndiceSystems;
        Menu menu = new Menu(Vocabulary.forLocale((Locale)this.locale).getString((short)168));
        MenuSync property = new MenuSync((List<ReferenceSystem>)main, !filtered, derived, menu, new SelectionListener(action));
        menu.getProperties().put((Object)SELECTED_ITEM_KEY, (Object)property);
        this.controlValues.add((WritableValue<ReferenceSystem>)property);
        return menu;
    }

    public static ObjectProperty<ReferenceSystem> getSelectedProperty(Menu menu) {
        Object property;
        if (menu != null && (property = menu.getProperties().get((Object)SELECTED_ITEM_KEY)) instanceof MenuSync) {
            return (MenuSync)((Object)property);
        }
        return null;
    }

    protected void errorOccurred(FactoryException e) {
        OptionalDataDownloader.reportIfInstalling(e);
        Logging.recoverableException((Logger)LogHandler.LOGGER, RecentReferenceSystems.class, (String)"getReferenceSystems", (Throwable)e);
    }

    static void errorOccurred(String caller, Exception e) {
        Logging.recoverableException((Logger)LogHandler.LOGGER, RecentReferenceSystems.class, (String)caller, (Throwable)e);
    }

    private static final class Unverified {
        private final ReferenceSystem system;

        Unverified(ReferenceSystem system) {
            this.system = system;
        }

        ReferenceSystem find(IdentifiedObjectFinder finder) throws FactoryException {
            IdentifiedObject replacement;
            if (finder != null && (replacement = finder.findSingleton((IdentifiedObject)this.system)) instanceof ReferenceSystem) {
                return (ReferenceSystem)replacement;
            }
            return this.system;
        }
    }

    final class SelectionListener
    implements ChangeListener<ReferenceSystem> {
        final ChangeListener<ReferenceSystem> action;

        private SelectionListener(ChangeListener<ReferenceSystem> action) {
            this.action = action;
        }

        final RecentReferenceSystems owner() {
            return RecentReferenceSystems.this;
        }

        public void changed(ObservableValue<? extends ReferenceSystem> property, ReferenceSystem oldValue, ReferenceSystem newValue) {
            if (RecentReferenceSystems.this.isAdjusting) {
                this.action.changed(property, (Object)oldValue, (Object)newValue);
                return;
            }
            ComparisonMode mode = (ComparisonMode)RecentReferenceSystems.this.duplicationCriterion.get();
            if (newValue == OTHER) {
                CRSChooser chooser = new CRSChooser(RecentReferenceSystems.this.factory, (Envelope)RecentReferenceSystems.this.geographicAOI, RecentReferenceSystems.this.locale);
                newValue = chooser.showDialog(GUIUtilities.getWindow(property)).orElse(null);
                if (newValue == null) {
                    newValue = oldValue;
                } else {
                    ObservableList<ReferenceSystem> items = RecentReferenceSystems.this.referenceSystems;
                    int count = items.size() - 1;
                    boolean found = false;
                    for (int i = 0; i < count; ++i) {
                        if (!Utilities.deepEquals((Object)newValue, (Object)items.get(i), (ComparisonMode)mode)) continue;
                        if (i >= 1) {
                            items.set(i, (Object)newValue);
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (count >= 9) {
                            List<ReferenceSystem> selected = RecentReferenceSystems.this.getSelectedItems();
                            int i = count;
                            while (--i >= 1) {
                                if (selected.contains(items.get(i))) continue;
                                items.remove(i);
                                if (--count >= 9) continue;
                            }
                        }
                        items.add(Math.min(items.size(), 1), (Object)newValue);
                        RecentReferenceSystems.this.notifyChanges();
                    }
                }
                ((WritableValue)property).setValue((Object)newValue);
            }
            if (oldValue != newValue) {
                ObservableList<ReferenceSystem> items = RecentReferenceSystems.this.referenceSystems;
                int count = items.size() - 1;
                int i = Math.min(count, 2);
                while (--i >= 0) {
                    ReferenceSystem current = (ReferenceSystem)items.get(i);
                    if (!Utilities.deepEquals((Object)current, (Object)newValue, (ComparisonMode)mode)) continue;
                    this.action.changed(property, (Object)oldValue, (Object)current);
                    return;
                }
                i = count;
                while (--i >= 1) {
                    if (!Utilities.deepEquals((Object)items.get(i), (Object)newValue, (ComparisonMode)mode)) continue;
                    newValue = (ReferenceSystem)items.remove(i);
                    break;
                }
                items.add(Math.min(items.size(), 1), (Object)newValue);
                RecentReferenceSystems.this.notifyChanges();
                if (oldValue != newValue) {
                    this.action.changed(property, (Object)oldValue, (Object)newValue);
                }
                RecentChoices.useReferenceSystem(IdentifiedObjects.toString((Identifier)IdentifiedObjects.getIdentifier((IdentifiedObject)newValue, null)));
            }
        }
    }
}

