/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.visitor;

import java.util.HashSet;
import java.util.Set;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.visitor.Visitor;
import org.apache.sis.pending.geoapi.filter.BetweenComparisonOperator;
import org.apache.sis.pending.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.ValueReference;

public final class ListingPropertyVisitor
extends Visitor<Object, Set<String>> {
    private static final ListingPropertyVisitor INSTANCE = new ListingPropertyVisitor();

    private ListingPropertyVisitor() {
        this.setLogicalHandlers((f, names) -> {
            LogicalOperator filter = (LogicalOperator)f;
            for (Filter child : filter.getOperands()) {
                this.visit(child, names);
            }
        });
        this.setFilterHandler(ComparisonOperatorName.valueOf("PROPERTY_IS_BETWEEN"), (f, names) -> {
            BetweenComparisonOperator filter = (BetweenComparisonOperator)f;
            this.visit(filter.getExpression(), names);
            this.visit(filter.getLowerBoundary(), names);
            this.visit(filter.getUpperBoundary(), names);
        });
        this.setFilterHandler(ComparisonOperatorName.valueOf("PROPERTY_IS_LIKE"), (f, names) -> this.visit(f.getExpressions().get(0), names));
        this.setExpressionHandler("ValueReference", (e, names) -> {
            ValueReference expression = (ValueReference)e;
            names.add(expression.getXPath());
        });
    }

    @Override
    protected void typeNotFound(Enum<?> type, Filter<Object> filter, Set<String> xpaths) {
        for (Expression<Object, ?> f : filter.getExpressions()) {
            this.visit(f, xpaths);
        }
    }

    @Override
    protected void typeNotFound(String type, Expression<Object, ?> expression, Set<String> xpaths) {
        for (Expression<Object, ?> p : expression.getParameters()) {
            this.visit(p, xpaths);
        }
    }

    public static Set<String> xpaths(Filter<?> filter, Set<String> xpaths) {
        if (xpaths == null) {
            xpaths = new HashSet<String>();
        }
        if (filter != null) {
            INSTANCE.visit(filter, xpaths);
        }
        return xpaths;
    }

    public static Set<String> xpaths(Expression<?, ?> expression, Set<String> xpaths) {
        if (xpaths == null) {
            xpaths = new HashSet<String>();
        }
        if (expression != null) {
            INSTANCE.visit(expression, xpaths);
        }
        return xpaths;
    }
}

