/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.ZoneOffset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.vault.fs.io.DocViewFormat;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.DocViewTreeNode;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.jetbrains.annotations.NotNull;

public class VaultContentXMLContentCreator
implements ContentCreator {
    private static final String ACL_NOT_SUPPORTED_MSG = "Sling Initial Content - ACL statements are not supported yet . SLING issue: https://issues.apache.org/jira/browse/SLING-11060";
    private final VaultPackageAssembler packageAssembler;
    private final Queue<DocViewTreeNode> currentNodeStack = Collections.asLifoQueue(new ArrayDeque());
    private final JcrNamespaceRegistry namespaceRegistry;
    private final NamePathResolver npResolver;
    private final XMLStreamWriter writer;
    private String rootPath;
    private final boolean isFileDescriptorEntry;
    private boolean isFinished = false;
    private DocViewTreeNode rootNode = null;

    VaultContentXMLContentCreator(@NotNull String repositoryPath, @NotNull OutputStream targetOutputStream, @NotNull JcrNamespaceRegistry namespaceRegistry, @NotNull VaultPackageAssembler packageAssembler, boolean isFileDescriptorEntry) throws RepositoryException, FactoryConfigurationError {
        this.packageAssembler = packageAssembler;
        this.namespaceRegistry = namespaceRegistry;
        this.isFileDescriptorEntry = isFileDescriptorEntry;
        this.npResolver = new DefaultNamePathResolver((NamespaceRegistry)namespaceRegistry);
        try {
            this.writer = FormattingXmlStreamWriter.create((OutputStream)targetOutputStream, (OutputFormat)new DocViewFormat().getXmlOutputFormat());
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("Cannot create XML Writer " + e, (Throwable)e);
        }
        this.rootPath = repositoryPath;
    }

    public String getContentPackageEntryPath() throws NamespaceException {
        String suffix = this.isFileDescriptorEntry ? ".dir/.content.xml" : "/.content.xml";
        return "/jcr_root" + PlatformNameFormat.getPlatformPath((String)this.rootNode.getPath((NameResolver)this.npResolver)) + suffix;
    }

    public void createNode(String name, String primaryNodeType, String[] mixinNodeTypes) throws RepositoryException {
        DocViewTreeNode newNode;
        Name currentNodeName;
        if (this.rootNode == null) {
            currentNodeName = NameConstants.JCR_ROOT;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                this.rootPath = Text.getRelativeParent((String)this.rootPath, (int)1) + "/" + name;
            }
        } else {
            currentNodeName = this.npResolver.getQName(name);
        }
        String defaultNtType = this.isFileDescriptorEntry ? "nt:file" : "nt:unstructured";
        String toUsePrimaryNodeType = StringUtils.isNotBlank((CharSequence)primaryNodeType) ? primaryNodeType : defaultNtType;
        ArrayList<DocViewProperty2> currentProperties = new ArrayList<DocViewProperty2>();
        currentProperties.add(new DocViewProperty2(NameConstants.JCR_PRIMARYTYPE, toUsePrimaryNodeType));
        if (ArrayUtils.isNotEmpty((Object[])mixinNodeTypes)) {
            currentProperties.add(new DocViewProperty2(NameConstants.JCR_MIXINTYPES, Arrays.asList(mixinNodeTypes)));
        }
        if (this.rootNode == null) {
            this.rootNode = newNode = new DocViewTreeNode(this.rootPath, currentNodeName, currentProperties);
        } else {
            newNode = new DocViewTreeNode(this.rootNode.getPath((NameResolver)this.npResolver), currentNodeName, currentProperties);
            this.currentNodeStack.element().addChild(newNode);
        }
        this.currentNodeStack.add(newNode);
    }

    public void finishNode() throws RepositoryException {
        this.currentNodeStack.remove();
    }

    public void finish() throws RepositoryException {
        if (this.isFinished) {
            return;
        }
        this.isFinished = true;
        try {
            this.rootNode.write(this.writer, this.namespaceRegistry, Arrays.asList(this.namespaceRegistry.getPrefixes()));
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("Cannot close XML writer " + e, (Throwable)e);
        }
    }

    public void createProperty(String name, int propertyType, String value) throws RepositoryException {
        this.currentNodeStack.peek().getProperties().add(new DocViewProperty2(this.npResolver.getQName(name), value, propertyType == 0 ? 1 : propertyType));
    }

    public void createProperty(String name, int propertyType, String[] values) throws RepositoryException {
        this.currentNodeStack.peek().getProperties().add(new DocViewProperty2(this.npResolver.getQName(name), Arrays.asList(values), propertyType == 0 ? 1 : propertyType));
    }

    public void createProperty(String name, Object value) throws RepositoryException {
        Value jcrValue = this.createValue(name, value, -1);
        DocViewProperty2 property = DocViewProperty2.fromValues((Name)this.npResolver.getQName(name), (Value[])new Value[]{jcrValue}, (int)jcrValue.getType(), (boolean)false, (boolean)false, (boolean)false);
        this.currentNodeStack.peek().getProperties().add(property);
    }

    public void createProperty(String name, Object[] values) throws RepositoryException {
        try {
            AtomicInteger index = new AtomicInteger();
            Value[] jcrValues = (Value[])Arrays.stream(values).map(v -> {
                try {
                    return this.createValue(name, v, index.getAndIncrement());
                }
                catch (RepositoryException e) {
                    throw new UncheckedRepositoryException(e);
                }
            }).toArray(Value[]::new);
            int type = jcrValues.length == 0 ? 1 : jcrValues[0].getType();
            DocViewProperty2 property = DocViewProperty2.fromValues((Name)this.npResolver.getQName(name), (Value[])jcrValues, (int)type, (boolean)true, (boolean)false, (boolean)false);
            this.currentNodeStack.peek().getProperties().add(property);
        }
        catch (UncheckedRepositoryException e) {
            throw e.getCause();
        }
    }

    private Value createValue(String name, Object value, int index) throws RepositoryException {
        Value jcrValue;
        ValueFactory valueFactory = ValueFactoryImpl.getInstance();
        if (value instanceof String) {
            jcrValue = valueFactory.createValue((String)value);
        } else if (value instanceof Long) {
            jcrValue = valueFactory.createValue(((Long)value).longValue());
        } else if (value instanceof Double) {
            jcrValue = valueFactory.createValue(((Double)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            jcrValue = valueFactory.createValue((BigDecimal)value);
        } else if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC), Locale.ROOT);
            calendar.setTime((Date)value);
            jcrValue = valueFactory.createValue(calendar);
        } else if (value instanceof Calendar) {
            jcrValue = valueFactory.createValue((Calendar)value);
        } else if (value instanceof Boolean) {
            jcrValue = valueFactory.createValue(((Boolean)value).booleanValue());
        } else if (value instanceof InputStream) {
            String binaryPropertyEntryName = PlatformNameFormat.getPlatformName((String)name) + (index != -1 ? "[" + index + "]" : "") + ".binary";
            this.createBinary((InputStream)value, "/" + binaryPropertyEntryName);
            jcrValue = valueFactory.createValue("", 2);
        } else {
            throw new UnsupportedOperationException("Unsupported value type " + value.getClass());
        }
        return jcrValue;
    }

    private void createBinary(InputStream value, String suffix) throws RepositoryException {
        String path = "jcr_root" + PlatformNameFormat.getPlatformPath((String)this.currentNodeStack.peek().getPath((NameResolver)this.npResolver)) + suffix;
        try {
            this.packageAssembler.addEntry(path, value);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void createFileAndResourceNode(String name, InputStream data, String mimeType, long lastModified) throws RepositoryException {
        this.createNode(name, "nt:file", null);
        this.createBinary(data, "");
        this.createNode("jcr:content", "nt:resource", null);
        Date date = lastModified >= 0L ? new Date(lastModified) : new Date();
        this.createProperty("jcr:mimeType", mimeType);
        this.createProperty("jcr:lastModified", date);
    }

    public boolean switchCurrentNode(String subPath, String newNodeType) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createUser(String name, String password, Map<String, Object> extraProperties) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createGroup(String name, String[] members, Map<String, Object> extraProperties) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createAce(String principal, String[] grantedPrivileges, String[] deniedPrivileges, String order) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    public void createAce(String principalId, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removedRestrictionNames) {
        throw new UnsupportedOperationException(ACL_NOT_SUPPORTED_MSG);
    }

    static final class UncheckedRepositoryException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UncheckedRepositoryException(RepositoryException e) {
            super(e);
        }

        @Override
        public synchronized RepositoryException getCause() {
            return (RepositoryException)super.getCause();
        }
    }
}

