/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injector.CustomAnnotation;
import org.apache.sling.models.impl.injector.CustomAnnotationInjector;
import org.apache.sling.models.impl.injector.SimpleInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomInjectorTest {
    private ModelAdapterFactory factory;

    CustomInjectorTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{TestModel.class, CustomAnnotationModel.class});
    }

    @Test
    void testInjectorWhichDoesNotImplementAnnotationProcessor() {
        this.factory.injectors = Arrays.asList(new SimpleInjector());
        TestModel model = (TestModel)this.factory.getAdapter(new Object(), TestModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"test string", (Object)model.getTestString());
    }

    @Test
    void testInjectorWithCustomAnnotation() {
        CustomAnnotationInjector injector = new CustomAnnotationInjector();
        this.factory.injectors = Arrays.asList(new SimpleInjector(), injector);
        this.factory.injectAnnotationProcessorFactories = this.factory.injectAnnotationProcessorFactories = Collections.singletonList(injector);
        CustomAnnotationModel model = (CustomAnnotationModel)this.factory.getAdapter(new Object(), CustomAnnotationModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"default value", (Object)model.getDefaultString());
        Assertions.assertEquals((Object)"custom value", (Object)model.getCustomString());
    }

    @Model(adaptables={Object.class})
    public static interface TestModel {
        @Inject
        public String getTestString();
    }

    @Model(adaptables={Object.class})
    public static interface CustomAnnotationModel {
        @CustomAnnotation
        public String getDefaultString();

        @Inject
        public String getCustomString();
    }
}

