/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.type.DatasetResetTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;

public class JRCalculator
implements JRFillExpressionEvaluator {
    protected JRFillDataset dataset;
    protected Map<String, JRFillParameter> parsm;
    protected Map<String, JRFillField> fldsm;
    protected Map<String, JRFillVariable> varsm;
    protected Map<String, JRFillGroup> grpsm;
    protected JRFillVariable[] variables;
    protected JRFillGroup[] groups;
    protected JRFillElementDataset[] datasets;
    private JRFillVariable pageNumber;
    private JRFillVariable columnNumber;
    private final DatasetExpressionEvaluator evaluator;

    protected JRCalculator(DatasetExpressionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    protected JRCalculator(JREvaluator evaluator) {
        this((DatasetExpressionEvaluator)evaluator);
    }

    protected void init(JRFillDataset dataset) throws JRException {
        this.dataset = dataset;
        this.parsm = dataset.parametersMap;
        this.fldsm = dataset.fieldsMap;
        this.varsm = dataset.variablesMap;
        this.variables = dataset.variables;
        this.grpsm = dataset.groupsMap;
        this.groups = dataset.groups;
        this.datasets = dataset.elementDatasets;
        this.pageNumber = this.varsm.get("PAGE_NUMBER");
        this.columnNumber = this.varsm.get("COLUMN_NUMBER");
        WhenResourceMissingTypeEnum whenResourceMissingType = dataset.getWhenResourceMissingType();
        boolean ignoreNPE = JRPropertiesUtil.getInstance(this.getFillDataset().getJasperReportsContext()).getBooleanProperty(this.getFillDataset(), "net.sf.jasperreports.evaluator.ignore.npe", true);
        this.evaluator.init(this.parsm, this.fldsm, this.varsm, whenResourceMissingType, ignoreNPE);
    }

    public JRFillVariable getPageNumber() {
        return this.pageNumber;
    }

    public JRFillVariable getColumnNumber() {
        return this.columnNumber;
    }

    public void calculateVariables(boolean incrementDatasets) throws JRException {
        int i;
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                Object expressionValue = this.evaluate(variable.getExpression());
                Object newValue = variable.getIncrementer().increment(variable, expressionValue, AbstractValueProvider.getCurrentValueProvider());
                variable.setValue(newValue);
                variable.setInitialized(false);
                variable.setPreviousIncrementedValue(variable.getIncrementedValue());
                if (variable.getIncrementType() != IncrementTypeEnum.NONE) continue;
                variable.setIncrementedValue(variable.getValue());
            }
        }
        if (incrementDatasets && this.datasets != null && this.datasets.length > 0) {
            for (i = 0; i < this.datasets.length; ++i) {
                JRFillElementDataset elementDataset = this.datasets[i];
                elementDataset.evaluate(this);
                if (elementDataset.getIncrementType() != IncrementTypeEnum.NONE) continue;
                elementDataset.increment();
            }
        }
    }

    protected void recalculateVariables() throws JRException {
        if (this.variables != null) {
            for (JRFillVariable variable : this.variables) {
                variable.setIncrementedValue(variable.getPreviousIncrementedValue());
            }
        }
        this.calculateVariables(false);
    }

    public void estimateVariables() throws JRException {
        if (this.variables != null && this.variables.length > 0) {
            for (int i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                Object expressionValue = this.evaluateEstimated(variable.getExpression());
                Object newValue = variable.getIncrementer().increment(variable, expressionValue, AbstractValueProvider.getEstimatedValueProvider());
                variable.setEstimatedValue(newValue);
            }
        }
    }

    public void estimateGroupRuptures() throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group;
            int i;
            for (i = this.groups.length - 1; i >= 0; --i) {
                JRFillGroup group2 = this.groups[i];
                Object oldValue = this.evaluateOld(group2.getExpression());
                Object estimatedValue = this.evaluateEstimated(group2.getExpression());
                if (oldValue == null && estimatedValue != null || oldValue != null && !oldValue.equals(estimatedValue)) {
                    group2.setHasChanged(true);
                    continue;
                }
                group2.setHasChanged(false);
            }
            if (this.variables != null && this.variables.length > 0) {
                for (i = 0; i < this.variables.length; ++i) {
                    JRFillVariable variable = this.variables[i];
                    if (variable.getIncrementType() != IncrementTypeEnum.GROUP || !(group = this.grpsm.get(variable.getIncrementGroup())).hasChanged()) continue;
                    variable.setIncrementedValue(variable.getValue());
                }
            }
            this.estimateVariables();
            boolean groupHasChanged = false;
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                group = this.groups[i2];
                boolean isTopLevelChange = false;
                if (!groupHasChanged) {
                    Object oldValue = this.evaluateOld(group.getExpression());
                    Object estimatedValue = this.evaluateEstimated(group.getExpression());
                    if (oldValue == null && estimatedValue != null || oldValue != null && !oldValue.equals(estimatedValue)) {
                        groupHasChanged = true;
                        isTopLevelChange = true;
                    }
                }
                group.setHasChanged(groupHasChanged);
                group.setTopLevelChange(isTopLevelChange);
            }
        }
    }

    public void initializeVariables(ResetTypeEnum resetType, IncrementTypeEnum incrementType) throws JRException {
        int i;
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                this.incrementVariable(this.variables[i], incrementType);
                this.initializeVariable(this.variables[i], resetType);
            }
        }
        if (this.datasets != null && this.datasets.length > 0) {
            for (i = 0; i < this.datasets.length; ++i) {
                this.incrementDataset(this.datasets[i], incrementType);
                this.initializeDataset(this.datasets[i], resetType);
            }
        }
    }

    private void incrementVariable(JRFillVariable variable, IncrementTypeEnum incrementType) {
        if (variable.getIncrementType() != IncrementTypeEnum.NONE) {
            boolean toIncrement = false;
            boolean toSetPreviousValue = false;
            switch (incrementType) {
                case REPORT: {
                    toIncrement = true;
                    break;
                }
                case PAGE: {
                    toSetPreviousValue = toIncrement = variable.getIncrementType() == IncrementTypeEnum.PAGE || variable.getIncrementType() == IncrementTypeEnum.COLUMN;
                    break;
                }
                case COLUMN: {
                    toSetPreviousValue = toIncrement = variable.getIncrementType() == IncrementTypeEnum.COLUMN;
                    break;
                }
                case GROUP: {
                    if (variable.getIncrementType() != IncrementTypeEnum.GROUP) break;
                    JRFillGroup group = this.grpsm.get(variable.getIncrementGroup());
                    toIncrement = group.hasChanged();
                    break;
                }
            }
            if (toIncrement) {
                variable.setIncrementedValue(variable.getValue());
                if (toSetPreviousValue) {
                    variable.setPreviousIncrementedValue(variable.getValue());
                }
            }
        } else {
            variable.setIncrementedValue(variable.getValue());
        }
    }

    private void incrementDataset(JRFillElementDataset elementDataset, IncrementTypeEnum incrementType) {
        if (elementDataset.getIncrementType() != IncrementTypeEnum.NONE) {
            boolean toIncrement = false;
            switch (incrementType) {
                case REPORT: {
                    toIncrement = true;
                    break;
                }
                case PAGE: {
                    toIncrement = elementDataset.getIncrementType() == IncrementTypeEnum.PAGE || elementDataset.getIncrementType() == IncrementTypeEnum.COLUMN;
                    break;
                }
                case COLUMN: {
                    toIncrement = elementDataset.getIncrementType() == IncrementTypeEnum.COLUMN;
                    break;
                }
                case GROUP: {
                    if (elementDataset.getIncrementType() != IncrementTypeEnum.GROUP) break;
                    JRFillGroup group = this.grpsm.get(elementDataset.getIncrementGroup());
                    toIncrement = group.hasChanged();
                    break;
                }
            }
            if (toIncrement) {
                elementDataset.increment();
            }
        }
    }

    private void initializeVariable(JRFillVariable variable, ResetTypeEnum resetType) throws JRException {
        if (variable.getResetType() != ResetTypeEnum.NONE) {
            boolean toInitialize = false;
            boolean toSetOldValue = false;
            switch (resetType) {
                case REPORT: {
                    toInitialize = true;
                    break;
                }
                case PAGE: {
                    toSetOldValue = toInitialize = variable.getResetType() == ResetTypeEnum.PAGE || variable.getResetType() == ResetTypeEnum.COLUMN;
                    break;
                }
                case COLUMN: {
                    toSetOldValue = toInitialize = variable.getResetType() == ResetTypeEnum.COLUMN;
                    break;
                }
                case GROUP: {
                    if (variable.getResetType() != ResetTypeEnum.GROUP) break;
                    JRFillGroup group = this.grpsm.get(variable.getResetGroup());
                    toInitialize = group.hasChanged();
                    break;
                }
            }
            if (toInitialize) {
                variable.setValue(this.evaluate(variable.getInitialValueExpression()));
                variable.setInitialized(true);
                variable.setIncrementedValue(null);
                if (toSetOldValue) {
                    variable.setOldValue(variable.getValue());
                    variable.setPreviousIncrementedValue(null);
                }
            }
        } else {
            variable.setValue(this.evaluate(variable.getExpression()));
            variable.setIncrementedValue(variable.getValue());
        }
    }

    private void initializeDataset(JRFillElementDataset elementDataset, ResetTypeEnum resetType) {
        boolean toInitialize = false;
        switch (resetType) {
            case REPORT: {
                toInitialize = true;
                break;
            }
            case PAGE: {
                toInitialize = elementDataset.getDatasetResetType() == DatasetResetTypeEnum.PAGE || elementDataset.getDatasetResetType() == DatasetResetTypeEnum.COLUMN;
                break;
            }
            case COLUMN: {
                toInitialize = elementDataset.getDatasetResetType() == DatasetResetTypeEnum.COLUMN;
                break;
            }
            case GROUP: {
                if (elementDataset.getDatasetResetType() == DatasetResetTypeEnum.GROUP) {
                    JRFillGroup group = this.grpsm.get(elementDataset.getResetGroup());
                    toInitialize = group.hasChanged();
                    break;
                }
                if (elementDataset.getDatasetResetType() != DatasetResetTypeEnum.NONE) break;
                toInitialize = true;
                break;
            }
        }
        if (toInitialize) {
            elementDataset.initialize();
        }
    }

    @Override
    public Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
        Object value = null;
        switch (evaluationType) {
            case 1: {
                value = this.evaluateOld(expression);
                break;
            }
            case 2: {
                value = this.evaluateEstimated(expression);
                break;
            }
            default: {
                value = this.evaluate(expression);
            }
        }
        return value;
    }

    public Object evaluateOld(JRExpression expression) throws JRExpressionEvalException {
        return this.evaluator.evaluateOld(expression);
    }

    public Object evaluateEstimated(JRExpression expression) throws JRExpressionEvalException {
        return this.evaluator.evaluateEstimated(expression);
    }

    public Object evaluate(JRExpression expression) throws JRExpressionEvalException {
        return this.evaluator.evaluate(expression);
    }

    @Override
    public JRFillDataset getFillDataset() {
        return this.dataset;
    }
}

