/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.Optional;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Mercator;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class AuthalicMercator
extends AuthalicConversion {
    private static final long serialVersionUID = -3546152970105798436L;
    static final int TYPE = 3;

    AuthalicMercator(Mercator other) {
        super(null, other);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) {
        return Optional.of(new Envelope2D(null, -314.1592653589793, -1.4660765716752369, 628.3185307179587, 2.9321531433504737));
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03b2 = this.sin\u03b2(Math.sin(\u03c6));
        if (dstPts != null) {
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = MathFunctions.atanh(sin\u03b2);
        }
        return derivate ? new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.sqrt(1.0 - sin\u03b2 * sin\u03b2)) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts != dstPts || srcOff != dstOff) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            --dstOff;
            while (--numPts >= 0) {
                double \u03c6 = dstPts[dstOff += 2];
                dstPts[dstOff] = MathFunctions.atanh(this.sin\u03b2(Math.sin(\u03c6)));
            }
        }
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = srcPts[srcOff];
        dstPts[dstOff + 1] = this.\u03c6(Math.tanh(y));
    }
}

