/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.ivm.naming.NameNode;

public class JndiEncArtifact
implements Serializable {
    String path = new String();

    public JndiEncArtifact(IvmContext context) {
        NameNode node = context.mynode;
        do {
            this.path = node.getAtomicName() + "/" + this.path;
        } while ((node = node.getParent()) != null);
    }

    public Object readResolve() throws ObjectStreamException {
        ThreadContext thrdCntx = ThreadContext.getThreadContext();
        BeanContext deployment = thrdCntx.getBeanContext();
        Context cntx = deployment.getJndiEnc();
        try {
            Object obj = cntx.lookup(this.path);
            if (obj == null) {
                throw new InvalidObjectException("JNDI ENC context reference could not be properly resolved when bean instance was activated");
            }
            return obj;
        }
        catch (NamingException e) {
            throw (InvalidObjectException)new InvalidObjectException("JNDI ENC context reference could not be properly resolved due to a JNDI exception, when bean instance was activated").initCause(e);
        }
    }
}

