/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.shell;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="cluster", name="config-property-excluded", description="Display or set the config properties excluded from the cluster sync")
@Service
public class PropExcludedCommand
extends CellarCommandSupport {
    @Argument(index=0, name="excluded-properties", description="A list of comma separated properties excluded from the cluster sync", required=false, multiValued=false)
    String excludedProperties;
    @Reference
    private ConfigurationAdmin configurationAdmin;

    protected Object doExecute() throws Exception {
        Configuration nodeConfiguration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
        if (this.excludedProperties == null || this.excludedProperties.isEmpty()) {
            Dictionary properties;
            if (nodeConfiguration != null && (properties = nodeConfiguration.getProperties()) != null) {
                System.out.println(properties.get("config.excluded.properties"));
            }
        } else if (nodeConfiguration != null) {
            Dictionary properties = nodeConfiguration.getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("config.excluded.properties", this.excludedProperties);
            nodeConfiguration.update(properties);
        }
        return null;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

