/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;

public class PropertyPlaceholderDelegateRegistry
implements Registry {
    private final CamelContext context;
    private final Registry delegate;

    public PropertyPlaceholderDelegateRegistry(CamelContext context, Registry delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public Object lookupByName(String name) {
        try {
            if (!name.equals("properties")) {
                name = this.context.resolvePropertyPlaceholders(name);
            }
            return this.delegate.lookupByName(name);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        try {
            if (!name.equals("properties")) {
                name = this.context.resolvePropertyPlaceholders(name);
            }
            return this.delegate.lookupByNameAndType(name, type);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return this.delegate.findByTypeWithName(type);
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        return this.delegate.findByType(type);
    }

    @Override
    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }

    public Registry getRegistry() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

