/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.utils;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.unomi.shell.migration.utils.HttpRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    public static CloseableHttpClient initHttpClient(boolean trustAllCertificates, CredentialsProvider credentialsProvider) throws IOException {
        long requestStartTime = System.currentTimeMillis();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties();
        if (credentialsProvider != null) {
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        if (trustAllCertificates) {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }}, new SecureRandom());
                Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)).build();
                httpClientBuilder.setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketFactoryRegistry));
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                LOGGER.error("Error creating SSL Context", (Throwable)e);
            }
        } else {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
        }
        RequestConfig requestConfig = RequestConfig.custom().build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Init HttpClient executed in {}ms", (Object)(System.currentTimeMillis() - requestStartTime));
        }
        return httpClientBuilder.build();
    }

    public static String executeGetRequest(CloseableHttpClient httpClient, String url, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("accept", "application/json");
        return HttpUtils.getResponse(httpClient, url, headers, (HttpRequestBase)httpGet);
    }

    public static String executeHeadRequest(CloseableHttpClient httpClient, String url, Map<String, String> headers) throws IOException {
        HttpHead httpHead = new HttpHead(url);
        httpHead.addHeader("accept", "application/json");
        return HttpUtils.getResponse(httpClient, url, headers, (HttpRequestBase)httpHead);
    }

    public static String executeDeleteRequest(CloseableHttpClient httpClient, String url, Map<String, String> headers) throws IOException {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.addHeader("accept", "application/json");
        return HttpUtils.getResponse(httpClient, url, headers, (HttpRequestBase)httpDelete);
    }

    public static String executePostRequest(CloseableHttpClient httpClient, String url, String jsonData, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("accept", "application/json");
        if (jsonData != null) {
            StringEntity input = new StringEntity(jsonData, "UTF-8");
            input.setContentType("application/json");
            httpPost.setEntity((HttpEntity)input);
        }
        return HttpUtils.getResponse(httpClient, url, headers, (HttpRequestBase)httpPost);
    }

    public static String executePutRequest(CloseableHttpClient httpClient, String url, String jsonData, Map<String, String> headers) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("accept", "application/json");
        if (jsonData != null) {
            StringEntity input = new StringEntity(jsonData);
            input.setContentType("application/json");
            httpPut.setEntity((HttpEntity)input);
        }
        return HttpUtils.getResponse(httpClient, url, headers, (HttpRequestBase)httpPut);
    }

    private static String getResponse(CloseableHttpClient httpClient, String url, Map<String, String> headers, HttpRequestBase httpRequestBase) throws IOException {
        long requestStartTime = System.currentTimeMillis();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequestBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequestBase);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (statusCode >= 400) {
            throw new HttpRequestException("Couldn't execute " + String.valueOf(httpRequestBase) + " response: " + (entity != null ? EntityUtils.toString((HttpEntity)entity) : "n/a"), statusCode);
        }
        if (LOGGER.isDebugEnabled()) {
            if (entity != null) {
                entity = new BufferedHttpEntity(response.getEntity());
            }
            LOGGER.debug("Request {} executed with code: {} and message: {}", new Object[]{httpRequestBase, statusCode, entity != null ? EntityUtils.toString((HttpEntity)entity) : null});
            LOGGER.debug("Request to Apache Unomi url: {} executed in {}ms", (Object)url, (Object)(System.currentTimeMillis() - requestStartTime));
        }
        if (entity == null) {
            return null;
        }
        String stringResponse = EntityUtils.toString((HttpEntity)entity);
        EntityUtils.consumeQuietly((HttpEntity)entity);
        return stringResponse;
    }
}

