/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.DCTFilter;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.pdfbox.PDFBoolean;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapterUtil;
import org.apache.fop.render.pdf.pdfbox.PDFString;
import org.apache.fop.render.pdf.pdfbox.PDFWriter;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class PDFCloner {
    private boolean trailer;
    private PDFBoxAdapter adapter;

    PDFCloner(PDFBoxAdapter adapter, boolean trailer) {
        this.adapter = adapter;
        this.trailer = trailer;
    }

    protected Object cloneForNewDocument(Object base) throws IOException {
        return this.cloneForNewDocument(base, base);
    }

    protected Object cloneForNewDocument(Object base, Object keyBase) throws IOException {
        return this.cloneForNewDocument(base, keyBase, Collections.EMPTY_LIST);
    }

    protected Object cloneForNewDocument(Object base, Object keyBase, Collection exclude) throws IOException {
        if (base == null) {
            return null;
        }
        Object cached = this.adapter.getCachedClone(keyBase);
        if (cached != null) {
            return cached;
        }
        if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            COSBase o = ((COSObjectable)base).getCOSObject();
            Object retval = this.cloneForNewDocument(o, o, exclude);
            return this.cacheClonedObject(keyBase, retval);
        }
        if (base instanceof COSObject) {
            return this.readCOSObject((COSObject)base, exclude);
        }
        if (base instanceof COSArray) {
            PDFArray newArray = new PDFArray();
            this.cacheClonedObject(keyBase, newArray);
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                newArray.add(this.cloneForNewDocument(array.get(i), array.get(i), exclude));
            }
            return newArray;
        }
        if (base instanceof COSStream) {
            return this.readCOSStream((COSStream)base, keyBase);
        }
        if (base instanceof COSDictionary) {
            return this.readCOSDictionary((COSDictionary)base, keyBase, exclude);
        }
        if (base instanceof COSName) {
            PDFName newName = new PDFName(((COSName)base).getName());
            return this.cacheClonedObject(keyBase, newName);
        }
        if (base instanceof COSInteger) {
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)((COSInteger)base).longValue());
            return this.cacheClonedObject(keyBase, number);
        }
        if (base instanceof COSFloat) {
            PDFNumber number = new PDFNumber();
            number.setNumber((Number)Float.valueOf(((COSFloat)base).floatValue()));
            return this.cacheClonedObject(keyBase, number);
        }
        if (base instanceof COSBoolean) {
            Boolean retval = ((COSBoolean)base).getValueAsObject();
            if (keyBase instanceof COSObject) {
                return this.cacheClonedObject(keyBase, (Object)new PDFBoolean(retval));
            }
            return this.cacheClonedObject(keyBase, retval);
        }
        if (base instanceof COSString) {
            return this.readCOSString((COSString)base, keyBase);
        }
        if (base instanceof COSNull) {
            return this.cacheClonedObject(keyBase, null);
        }
        throw new UnsupportedOperationException("NYI: " + base.getClass().getName());
    }

    protected Object readCOSObject(COSObject object, Collection exclude) throws IOException {
        PDFObject pdfobj;
        Object obj = this.cloneForNewDocument(object.getObject(), object, exclude);
        if (obj instanceof PDFObject && !(pdfobj = (PDFObject)obj).hasObjectNumber()) {
            throw new IllegalStateException("PDF object was not registered!");
        }
        return obj;
    }

    private PDFDictionary readCOSDictionary(COSDictionary dic, Object keyBase, Collection exclude) throws IOException {
        PDFDictionary newDict = new PDFDictionary();
        this.cacheClonedObject(keyBase, newDict);
        for (Map.Entry e : dic.entrySet()) {
            if (exclude.contains(e.getKey())) continue;
            String name = ((COSName)e.getKey()).getName();
            if (this.adapter.uniqueName != null) {
                name = this.adapter.uniqueName.getName((COSName)e.getKey());
            }
            newDict.put(name, this.cloneForNewDocument(e.getValue(), e.getValue(), exclude));
        }
        return newDict;
    }

    private Object readCOSString(COSString string, Object keyBase) throws IOException {
        byte[] bytes = string.getBytes();
        if (keyBase instanceof COSObject) {
            return this.cacheClonedObject(keyBase, (Object)new PDFString(bytes));
        }
        if (PDFString.isUSASCII(bytes)) {
            return this.cacheClonedObject(keyBase, new String(string.getBytes(), "ISO-8859-1"));
        }
        return this.cacheClonedObject(keyBase, bytes);
    }

    private Object readCOSStream(COSStream originalStream, Object keyBase) throws IOException {
        OutputStream out;
        Set<String> filter;
        Object in;
        PDFStream stream;
        block20: {
            stream = new PDFStream();
            if (this.adapter.pdfDoc.isEncryptionActive() && originalStream.getItem(COSName.FILTER) == COSName.DCT_DECODE) {
                stream.getFilterList().addFilter((PDFFilter)new DCTFilter());
                in = originalStream.createRawInputStream();
                filter = Collections.EMPTY_SET;
            } else if (this.adapter.pdfDoc.isEncryptionActive() || originalStream.containsKey(COSName.DECODE_PARMS) && !originalStream.containsKey(COSName.FILTER)) {
                in = originalStream.createInputStream();
                filter = PDFBoxAdapter.FILTER_FILTER;
            } else {
                in = originalStream.createRawInputStream();
                filter = Collections.EMPTY_SET;
            }
            out = stream.getBufferOutputStream();
            if ((originalStream.getItem(COSName.TYPE) == COSName.PATTERN || originalStream.getItem(COSName.SUBTYPE) == COSName.FORM) && this.adapter.uniqueName != null) {
                PDFWriter writer = new PDFWriter(this.adapter.uniqueName, this.adapter.currentMCID);
                try {
                    String newStream = writer.writeText(new PDStream(originalStream));
                    if (!writer.keyUsed) break block20;
                    filter = PDFBoxAdapter.FILTER_FILTER;
                    byte[] bytes = newStream.getBytes("ISO-8859-1");
                    out.write(bytes);
                    out.close();
                    try (OutputStream originalStreamOS = originalStream.createOutputStream();){
                        originalStreamOS.write(bytes);
                    }
                    in = null;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (in != null) {
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        }
        this.adapter.transferDict((COSDictionary)originalStream, stream, filter);
        return this.cacheClonedObject(keyBase, stream);
    }

    protected Object cacheClonedObject(Object base, Object cloned) throws IOException {
        Object key = PDFBoxAdapterUtil.getBaseKey(base);
        if (key == null) {
            return cloned;
        }
        PDFObject pdfobj = (PDFObject)cloned;
        if (pdfobj != null && !pdfobj.hasObjectNumber() && !(base instanceof COSDictionary)) {
            if (this.trailer) {
                this.adapter.pdfDoc.registerTrailerObject(pdfobj);
            } else {
                this.adapter.pdfDoc.registerObject(pdfobj);
            }
        }
        this.adapter.clonedVersion.put(key, cloned);
        if (key instanceof Integer) {
            this.adapter.objectCache.put(key, cloned);
        }
        return cloned;
    }
}

